/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.common.StreamUtils;
import io.milton.http.AbstractRequest;
import io.milton.http.AbstractResponse;
import io.milton.http.Auth;
import io.milton.http.Cookie;
import io.milton.http.FileItem;
import io.milton.http.Filter;
import io.milton.http.FilterChain;
import io.milton.http.Request;
import io.milton.http.RequestParseException;
import io.milton.http.Response;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DebugFilter.class);
    private static int counter = 0;
    private File logDir;

    public DebugFilter() {
        this.logDir = new File(System.getProperty("java.io.tmpdir"));
        log.info("DebugFilter is logging requests to: " + this.logDir.getAbsolutePath());
    }

    public DebugFilter(File logDir) {
        this.logDir = logDir;
        log.info("DebugFilter is logging requests to: " + logDir.getAbsolutePath());
    }

    @Override
    public void process(FilterChain chain, Request request, Response response) {
        log.info("process: " + request.getMethod() + " " + request.getAbsolutePath());
        DebugRequest req2 = new DebugRequest(request);
        final DebugResponse resp2 = new DebugResponse(response);
        resp2.setEntity(new Response.Entity(){

            public void write(Response response, OutputStream outputStream) throws Exception {
                try {
                    outputStream.write(resp2.out.toByteArray());
                    outputStream.flush();
                }
                catch (IOException ex) {
                    log.error("", (Throwable)ex);
                }
            }
        });
        chain.process(req2, resp2);
        this.record(req2, resp2);
        System.out.println("set response entity on: " + response.getClass());
    }

    private synchronized void record(DebugRequest req2, DebugResponse resp2) {
        File f;
        ++counter;
        FileOutputStream fout = null;
        try {
            f = new File(this.logDir, counter + "_" + req2.getMethod() + ".req");
            log.info("Save request to: " + f.getAbsolutePath());
            fout = new FileOutputStream(f);
            req2.record(fout);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                StreamUtils.close(fout);
                throw throwable;
            }
        }
        StreamUtils.close((OutputStream)fout);
        try {
            f = resp2.getStatus() != null ? new File(this.logDir, counter + "_" + resp2.getStatus().code + ".resp") : new File(this.logDir, counter + "_UNKNOWN" + ".resp");
            log.info("Save response to: " + f.getAbsolutePath());
            fout = new FileOutputStream(f);
            resp2.record(fout);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            StreamUtils.close((OutputStream)fout);
        }
    }

    public class DebugRequest
    extends AbstractRequest {
        final Request r;
        final byte[] contentBytes;
        final ByteArrayInputStream content;

        public DebugRequest(Request r) {
            this.r = r;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                StreamUtils.readTo((InputStream)r.getInputStream(), (OutputStream)out);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.contentBytes = out.toByteArray();
            this.content = new ByteArrayInputStream(this.contentBytes);
            log.debug(out.toString());
        }

        public Map<String, String> getHeaders() {
            return this.r.getHeaders();
        }

        @Override
        public String getRequestHeader(Request.Header header) {
            return this.r.getRequestHeader(header);
        }

        public String getFromAddress() {
            return this.r.getFromAddress();
        }

        public Request.Method getMethod() {
            return this.r.getMethod();
        }

        public Auth getAuthorization() {
            return this.r.getAuthorization();
        }

        public void setAuthorization(Auth auth) {
            this.r.setAuthorization(auth);
        }

        public String getAbsoluteUrl() {
            return this.r.getAbsoluteUrl();
        }

        public InputStream getInputStream() throws IOException {
            return this.content;
        }

        public void parseRequestParameters(Map<String, String> params, Map<String, FileItem> files) throws RequestParseException {
            this.r.parseRequestParameters(params, files);
        }

        public void record(OutputStream out) {
            PrintWriter writer = new PrintWriter(out);
            writer.println(this.getMethod() + " " + this.getAbsolutePath() + " HTTP/1.1");
            for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
                writer.println(header.getKey() + ": " + header.getValue());
            }
            writer.flush();
            try {
                out.write(this.contentBytes);
            }
            catch (IOException ex) {
                log.error("", (Throwable)ex);
            }
        }

        public Cookie getCookie(String name) {
            return this.r.getCookie(name);
        }

        public List<Cookie> getCookies() {
            return this.r.getCookies();
        }

        public String getRemoteAddr() {
            return this.r.getRemoteAddr();
        }
    }

    public class DebugResponse
    extends AbstractResponse {
        final Response r;
        final ByteArrayOutputStream out;
        List<String> challenges;

        public DebugResponse(Response r) {
            this.r = r;
            this.out = new ByteArrayOutputStream();
        }

        public Response.Status getStatus() {
            return this.r.getStatus();
        }

        public void setStatus(Response.Status status) {
            this.r.setStatus(status);
        }

        public void setNonStandardHeader(String code, String value) {
            this.r.setNonStandardHeader(code, value);
        }

        public String getNonStandardHeader(String code) {
            return this.r.getNonStandardHeader(code);
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public void sendError(Response.Status status, String message) {
            this.r.sendError(status, message);
        }

        public Map<String, String> getHeaders() {
            return this.r.getHeaders();
        }

        private void record(FileOutputStream fout) {
            try {
                PrintWriter writer = new PrintWriter(fout);
                if (this.getStatus() != null) {
                    writer.println("HTTP/1.1 " + this.getStatus().code);
                }
                for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
                    writer.println(header.getKey() + ": " + header.getValue());
                }
                if (this.challenges != null) {
                    for (String ch : this.challenges) {
                        writer.println(Response.Header.WWW_AUTHENTICATE + ": " + ch);
                    }
                }
                writer.flush();
                log.info("request---");
                log.debug(this.out.toString());
                fout.write(this.out.toByteArray());
                fout.flush();
            }
            catch (IOException ex) {
                log.error("", (Throwable)ex);
            }
        }

        public void setAuthenticateHeader(List<String> challenges) {
            this.challenges = challenges;
            this.r.setAuthenticateHeader(challenges);
        }

        public Cookie setCookie(Cookie cookie) {
            return this.r.setCookie(cookie);
        }

        public Cookie setCookie(String name, String value) {
            return this.r.setCookie(name, value);
        }

        public void close() {
            this.r.close();
        }
    }
}

