/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ftp;

import io.milton.ftp.MiltonListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.impl.FtpHandler;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.ListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonListenerFactory
extends ListenerFactory {
    private static final Logger log = LoggerFactory.getLogger(MiltonListenerFactory.class);
    private final FtpHandler ftpHandler;

    public MiltonListenerFactory(FtpHandler ftpHandler) {
        this.ftpHandler = ftpHandler;
    }

    public Listener createListener() {
        try {
            InetAddress.getByName(this.getServerAddress());
        }
        catch (UnknownHostException e) {
            throw new FtpServerConfigurationException("Unknown host", (Throwable)e);
        }
        log.debug("Creating milton listener");
        return new MiltonListener(this.getServerAddress(), this.getPort(), this.isImplicitSsl(), this.getSslConfiguration(), this.getDataConnectionConfiguration(), this.getIdleTimeout(), this.getBlockedAddresses(), this.getBlockedSubnets(), this.ftpHandler);
    }
}

