/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ftp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.impl.FtpHandler;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.nio.AbstractListener;
import org.apache.ftpserver.listener.nio.FtpHandlerAdapter;
import org.apache.ftpserver.listener.nio.FtpLoggingFilter;
import org.apache.ftpserver.listener.nio.FtpServerProtocolCodecFactory;
import org.apache.ftpserver.listener.nio.NioListener;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.executor.OrderedThreadPoolExecutor;
import org.apache.mina.filter.firewall.BlacklistFilter;
import org.apache.mina.filter.firewall.Subnet;
import org.apache.mina.filter.logging.MdcInjectionFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonListener
extends AbstractListener {
    private final Logger LOG = LoggerFactory.getLogger(NioListener.class);
    private SocketAcceptor acceptor;
    private InetSocketAddress address;
    boolean suspended = false;
    private ExecutorService filterExecutor = new OrderedThreadPoolExecutor();
    private final FtpHandler handler;
    private FtpServerContext context;

    public MiltonListener(String serverAddress, int port, boolean implicitSsl, SslConfiguration sslConfiguration, DataConnectionConfiguration dataConnectionConfig, int idleTimeout, List<InetAddress> blockedAddresses, List<Subnet> blockedSubnets, FtpHandler handler) {
        super(serverAddress, port, implicitSsl, sslConfiguration, dataConnectionConfig, idleTimeout, blockedAddresses, blockedSubnets);
        this.handler = handler;
        this.updateBlacklistFilter();
    }

    private void updateBlacklistFilter() {
        BlacklistFilter filter;
        if (this.acceptor != null && (filter = (BlacklistFilter)this.acceptor.getFilterChain().get("ipFilter")) != null) {
            if (this.getBlockedAddresses() != null) {
                filter.setBlacklist((Iterable)this.getBlockedAddresses());
            } else if (this.getBlockedSubnets() != null) {
                filter.setSubnetBlacklist((Iterable)this.getBlockedSubnets());
            } else {
                filter.setSubnetBlacklist(new ArrayList());
            }
        }
    }

    public synchronized void start(FtpServerContext context) {
        try {
            this.context = context;
            this.acceptor = new NioSocketAcceptor(Runtime.getRuntime().availableProcessors());
            this.address = this.getServerAddress() != null ? new InetSocketAddress(this.getServerAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
            this.acceptor.setReuseAddress(true);
            this.acceptor.getSessionConfig().setReadBufferSize(2048);
            this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, this.getIdleTimeout());
            this.acceptor.getSessionConfig().setReceiveBufferSize(512);
            MdcInjectionFilter mdcFilter = new MdcInjectionFilter();
            this.acceptor.getFilterChain().addLast("mdcFilter", (IoFilter)mdcFilter);
            this.acceptor.getFilterChain().addLast("ipFilter", (IoFilter)new BlacklistFilter());
            this.updateBlacklistFilter();
            this.acceptor.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.filterExecutor));
            this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new FtpServerProtocolCodecFactory()));
            this.acceptor.getFilterChain().addLast("mdcFilter2", (IoFilter)mdcFilter);
            this.acceptor.getFilterChain().addLast("logger", (IoFilter)new FtpLoggingFilter());
            if (this.isImplicitSsl()) {
                SslFilter sslFilter;
                SslConfiguration ssl = this.getSslConfiguration();
                try {
                    sslFilter = new SslFilter(ssl.getSSLContext());
                }
                catch (GeneralSecurityException e) {
                    throw new FtpServerConfigurationException("SSL could not be initialized, check configuration");
                }
                if (ssl.getClientAuth() == ClientAuth.NEED) {
                    sslFilter.setNeedClientAuth(true);
                } else if (ssl.getClientAuth() == ClientAuth.WANT) {
                    sslFilter.setWantClientAuth(true);
                }
                if (ssl.getEnabledCipherSuites() != null) {
                    sslFilter.setEnabledCipherSuites(ssl.getEnabledCipherSuites());
                }
                this.acceptor.getFilterChain().addFirst("sslFilter", (IoFilter)sslFilter);
            }
            this.handler.init(context, (Listener)this);
            this.acceptor.setHandler((IoHandler)new FtpHandlerAdapter(context, this.handler));
            try {
                this.acceptor.bind((SocketAddress)this.address);
            }
            catch (IOException e) {
                throw new FtpServerConfigurationException("Failed to bind to address " + this.address + ", check configuration", (Throwable)e);
            }
            this.updatePort();
        }
        catch (RuntimeException e) {
            this.stop();
            throw e;
        }
    }

    private void updatePort() {
        this.setPort(this.acceptor.getLocalAddress().getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.acceptor != null) {
            this.acceptor.unbind();
            this.acceptor.dispose();
            this.acceptor = null;
        }
        if (this.filterExecutor != null) {
            this.filterExecutor.shutdown();
            try {
                this.filterExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.context = null;
    }

    public boolean isStopped() {
        return this.acceptor == null;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public synchronized void resume() {
        if (this.acceptor != null && this.suspended) {
            try {
                this.LOG.debug("Resuming listener");
                this.acceptor.bind((SocketAddress)this.address);
                this.LOG.debug("Listener resumed");
                this.updatePort();
            }
            catch (IOException e) {
                this.LOG.error("Failed to resume listener", (Throwable)e);
            }
        }
    }

    public synchronized void suspend() {
        if (this.acceptor != null && !this.suspended) {
            this.LOG.debug("Suspending listener");
            this.acceptor.unbind();
            this.suspended = true;
            this.LOG.debug("Listener suspended");
        }
    }

    public synchronized Set<FtpIoSession> getActiveSessions() {
        Map sessions = this.acceptor.getManagedSessions();
        HashSet<FtpIoSession> ftpSessions = new HashSet<FtpIoSession>();
        for (IoSession session : sessions.values()) {
            ftpSessions.add(new FtpIoSession(session, this.context));
        }
        return ftpSessions;
    }
}

