/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ftp;

import io.milton.common.BufferingOutputStream;
import io.milton.common.Path;
import io.milton.ftp.FtpRequest;
import io.milton.ftp.MiltonFsView;
import io.milton.ftp.MiltonUser;
import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.resource.CollectionResource;
import io.milton.resource.DeletableResource;
import io.milton.resource.GetableResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.MoveableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.ReplaceableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.ftplet.FtpFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonFtpFile
implements FtpFile {
    private static final Logger log = LoggerFactory.getLogger(MiltonFtpFile.class);
    private final Path path;
    private CollectionResource parent;
    private final MiltonFsView ftpFactory;
    private Resource r;
    private final MiltonUser user;

    public MiltonFtpFile(MiltonFsView resourceFactory, Path path, Resource r, MiltonUser user) {
        this.path = path;
        this.r = r;
        this.parent = null;
        this.ftpFactory = resourceFactory;
        this.user = user;
    }

    public MiltonFtpFile(MiltonFsView resourceFactory, Path path, CollectionResource parent, Resource r, MiltonUser user) {
        this.path = path;
        this.r = null;
        this.parent = parent;
        this.ftpFactory = resourceFactory;
        this.user = user;
    }

    public String getAbsolutePath() {
        return this.path.toString();
    }

    public String getName() {
        return this.r.getName();
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isDirectory() {
        return this.r instanceof CollectionResource;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean doesExist() {
        return this.r != null;
    }

    public boolean isReadable() {
        log.debug("isReadble");
        if (this.r == null || !(this.r instanceof GetableResource)) {
            return false;
        }
        Auth auth = new Auth(this.user.getName(), this.user.getUser());
        FtpRequest request = new FtpRequest(Request.Method.GET, auth, this.path.toString());
        return this.r.authorise((Request)request, request.getMethod(), auth);
    }

    public boolean isWritable() {
        try {
            log.debug("isWritable: " + this.getAbsolutePath());
            if (this.path.isRoot()) {
                return false;
            }
            Auth auth = new Auth(this.user.getName(), this.user.getUser());
            FtpRequest request = new FtpRequest(Request.Method.DELETE, auth, this.path.toString());
            if (this.r != null && this.r instanceof ReplaceableResource) {
                return this.r.authorise((Request)request, Request.Method.PUT, auth);
            }
            if (this.getParent() instanceof PutableResource) {
                return this.getParent().authorise((Request)request, Request.Method.PUT, auth);
            }
            return false;
        }
        catch (NotAuthorizedException ex) {
            throw new RuntimeException(ex);
        }
        catch (BadRequestException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isRemovable() {
        log.debug("isRemovable: " + this.getAbsolutePath());
        if (this.r == null) {
            return false;
        }
        if (this.path.isRoot()) {
            return false;
        }
        Auth auth = new Auth(this.user.getName(), this.user.getUser());
        FtpRequest request = new FtpRequest(Request.Method.DELETE, auth, this.path.toString());
        boolean b = this.r.authorise((Request)request, Request.Method.DELETE, auth);
        log.debug(".. = " + b);
        return b;
    }

    public String getOwnerName() {
        return "anyone";
    }

    public String getGroupName() {
        return "anygroup";
    }

    public int getLinkCount() {
        return 0;
    }

    public long getLastModified() {
        if (this.r.getModifiedDate() != null) {
            return this.r.getModifiedDate().getTime();
        }
        return System.currentTimeMillis();
    }

    public boolean setLastModified(long time) {
        return false;
    }

    public long getSize() {
        if (this.r instanceof GetableResource) {
            GetableResource gr = (GetableResource)this.r;
            Long ll = gr.getContentLength();
            if (ll == null) {
                return 0L;
            }
            return ll;
        }
        return 0L;
    }

    public boolean mkdir() {
        log.debug("mkdir: " + this.path);
        if (this.parent != null) {
            if (this.parent instanceof MakeCollectionableResource) {
                MakeCollectionableResource mcr = (MakeCollectionableResource)this.parent;
                try {
                    this.r = mcr.createCollection(this.path.getName());
                    return true;
                }
                catch (NotAuthorizedException ex) {
                    log.debug("no authorised");
                    return false;
                }
                catch (BadRequestException ex) {
                    return false;
                }
                catch (ConflictException ex) {
                    log.debug("conflict");
                    return false;
                }
            }
            log.debug("parent does not support creating collection");
            return false;
        }
        throw new RuntimeException("no parent");
    }

    public boolean delete() {
        if (this.r instanceof DeletableResource) {
            DeletableResource dr = (DeletableResource)this.r;
            try {
                dr.delete();
            }
            catch (NotAuthorizedException ex) {
                log.warn("can't delete, not authorised");
                return false;
            }
            catch (ConflictException ex) {
                log.warn("can't delete, conflct");
                return false;
            }
            catch (BadRequestException ex) {
                log.warn("can't delete, bad request");
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean move(FtpFile newFile) {
        if (this.r == null) {
            throw new RuntimeException("resource not saved yet");
        }
        if (this.r instanceof MoveableResource) {
            try {
                MoveableResource src = (MoveableResource)this.r;
                MiltonFtpFile dest = (MiltonFtpFile)newFile;
                CollectionResource crDest = dest.getParent();
                String newName = dest.path.getName();
                try {
                    src.moveTo(crDest, newName);
                    return true;
                }
                catch (BadRequestException ex) {
                    log.error("bad request, can't move", (Throwable)ex);
                    return false;
                }
                catch (NotAuthorizedException ex) {
                    log.error("not authorised can't move", (Throwable)ex);
                    return false;
                }
                catch (ConflictException ex) {
                    log.error("can't move", (Throwable)ex);
                    return false;
                }
            }
            catch (NotAuthorizedException ex) {
                throw new RuntimeException(ex);
            }
            catch (BadRequestException ex) {
                throw new RuntimeException(ex);
            }
        }
        log.debug("not moveable: " + this.getName());
        return false;
    }

    public List<FtpFile> listFiles() {
        log.debug("listfiles");
        ArrayList<FtpFile> list = new ArrayList<FtpFile>();
        if (this.r instanceof CollectionResource) {
            try {
                CollectionResource cr = (CollectionResource)this.r;
                for (Resource child : cr.getChildren()) {
                    list.add(this.ftpFactory.wrap(this.path.child(child.getName()), child));
                }
            }
            catch (NotAuthorizedException ex) {
                throw new RuntimeException(ex);
            }
            catch (BadRequestException ex) {
                throw new RuntimeException(ex);
            }
        }
        return list;
    }

    public OutputStream createOutputStream(long offset) throws IOException {
        CollectionResource col;
        log.debug("createOutputStream: " + offset);
        final BufferingOutputStream out = new BufferingOutputStream(50000);
        if (this.r instanceof ReplaceableResource) {
            log.debug("resource is replaceable");
            final ReplaceableResource rr = (ReplaceableResource)this.r;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        rr.replaceContent(out.getInputStream(), Long.valueOf(out.getSize()));
                    }
                    catch (BadRequestException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (ConflictException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (NotAuthorizedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
            out.setOnClose(runnable);
            return out;
        }
        try {
            col = this.getParent();
        }
        catch (NotAuthorizedException ex) {
            throw new RuntimeException(ex);
        }
        catch (BadRequestException ex) {
            throw new RuntimeException(ex);
        }
        if (col == null) {
            throw new IOException("parent not found");
        }
        if (col instanceof PutableResource) {
            final PutableResource putableResource = (PutableResource)col;
            final String newName = this.path.getName();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        putableResource.createNew(newName, out.getInputStream(), Long.valueOf(out.getSize()), null);
                    }
                    catch (BadRequestException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (NotAuthorizedException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (ConflictException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
            out.setOnClose(runnable);
            return out;
        }
        throw new IOException("folder doesnt support PUT, and the resource is not replaceable");
    }

    public InputStream createInputStream(long offset) throws IOException {
        if (this.r instanceof GetableResource) {
            GetableResource gr = (GetableResource)this.r;
            String ct = gr.getContentType(null);
            BufferingOutputStream out = new BufferingOutputStream(50000);
            try {
                gr.sendContent((OutputStream)out, null, null, ct);
                out.close();
                return out.getInputStream();
            }
            catch (NotFoundException ex) {
                log.warn("Not found exception", (Throwable)ex);
                return null;
            }
            catch (BadRequestException ex) {
                log.warn("bad request", (Throwable)ex);
                return null;
            }
            catch (NotAuthorizedException ex) {
                log.warn("not authorising", (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    private CollectionResource getParent() throws NotAuthorizedException, BadRequestException {
        if (this.parent == null) {
            MiltonFsView.ResourceAndPath rp = this.ftpFactory.getResource(this.path.getParent());
            if (rp.resource == null) {
                throw new RuntimeException("couldnt find parent: " + this.path);
            }
            this.parent = (CollectionResource)rp.resource;
        }
        return this.parent;
    }
}

