/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ftp;

import io.milton.common.Path;
import io.milton.ftp.MiltonFtpFile;
import io.milton.ftp.MiltonUser;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import io.milton.resource.Resource;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonFsView
implements FileSystemView {
    private static final Logger log = LoggerFactory.getLogger(MiltonFsView.class);
    Path homePath;
    CollectionResource home;
    Path currentPath;
    CollectionResource current;
    final ResourceFactory resourceFactory;
    final MiltonUser user;

    public MiltonFsView(Path homePath, CollectionResource current, ResourceFactory resourceFactory, MiltonUser user) {
        this.user = user;
        if (homePath.isRelative()) {
            throw new IllegalArgumentException("homePath must be absolute");
        }
        this.homePath = homePath;
        this.currentPath = homePath;
        this.current = current;
        this.home = current;
        this.resourceFactory = resourceFactory;
        log.debug("created view on resource: " + current.getName() + " for user: " + user.name + "@" + user.domain);
    }

    public FtpFile getHomeDirectory() throws FtpException {
        return this.wrap(this.homePath, (Resource)this.home);
    }

    public FtpFile getWorkingDirectory() throws FtpException {
        return this.wrap(this.homePath, (Resource)this.current);
    }

    public boolean changeWorkingDirectory(String dir) throws FtpException {
        try {
            log.debug("cd: " + dir + " from " + this.currentPath);
            Path p = Path.path((String)dir);
            ResourceAndPath rp = this.getResource(p);
            if (rp.resource == null) {
                log.debug("not found: " + p);
                return false;
            }
            if (rp.resource instanceof CollectionResource) {
                this.current = (CollectionResource)rp.resource;
                this.currentPath = rp.path;
                log.debug("currentPath is now: " + this.currentPath);
                return true;
            }
            log.debug("not a collection: " + rp.resource.getName());
            return false;
        }
        catch (NotAuthorizedException ex) {
            throw new FtpException((Throwable)ex);
        }
        catch (BadRequestException ex) {
            throw new FtpException((Throwable)ex);
        }
    }

    public FtpFile getFile(String path) throws FtpException {
        try {
            log.debug("getFile: " + path);
            if (path.startsWith(".")) {
                path = this.currentPath.toString() + path.substring(1);
                log.debug("getFile2: " + path);
            }
            Path p = Path.path((String)path);
            ResourceAndPath rp = this.getResource(p);
            if (rp.resource == null) {
                log.debug("returning new file");
                return new MiltonFtpFile(this, rp.path, this.current, null, this.user);
            }
            return new MiltonFtpFile(this, rp.path, rp.resource, this.user);
        }
        catch (NotAuthorizedException ex) {
            throw new FtpException((Throwable)ex);
        }
        catch (BadRequestException ex) {
            throw new FtpException((Throwable)ex);
        }
    }

    public boolean isRandomAccessible() throws FtpException {
        return true;
    }

    public void dispose() {
    }

    public ResourceAndPath getResource(Path p) throws NotAuthorizedException, BadRequestException {
        log.debug("getResource: " + p);
        if (p.isRelative()) {
            p = Path.path((String)(this.currentPath.toString() + '/' + p.toString()));
            Resource r = this.resourceFactory.getResource(this.user.domain, p.toString());
            return new ResourceAndPath(r, p);
        }
        Resource r = this.resourceFactory.getResource(this.user.domain, p.toString());
        return new ResourceAndPath(r, p);
    }

    public FtpFile wrap(Path path, Resource r) {
        return new MiltonFtpFile(this, path, r, this.user);
    }

    public static class ResourceAndPath {
        final Resource resource;
        final Path path;

        public ResourceAndPath(Resource r, Path p) {
            if (p == null) {
                throw new IllegalArgumentException("path may not be null");
            }
            if (p.isRelative()) {
                throw new IllegalArgumentException("path must be absolute");
            }
            this.resource = r;
            this.path = p;
        }
    }
}

