/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.server;

import io.milton.common.Service;
import io.milton.dns.Name;
import io.milton.dns.TextParseException;
import io.milton.dns.record.CNAMERecord;
import io.milton.dns.record.DNAMERecord;
import io.milton.dns.record.Header;
import io.milton.dns.record.Message;
import io.milton.dns.record.NameTooLongException;
import io.milton.dns.record.OPTRecord;
import io.milton.dns.record.RRset;
import io.milton.dns.record.Record;
import io.milton.dns.record.SOARecord;
import io.milton.dns.record.SetResponse;
import io.milton.dns.record.TSIG;
import io.milton.dns.record.TSIGRecord;
import io.milton.dns.record.Type;
import io.milton.dns.resource.DomainResource;
import io.milton.dns.resource.DomainResourceFactory;
import io.milton.dns.resource.DomainResourceRecord;
import io.milton.dns.resource.NonAuthoritativeException;
import io.milton.dns.resource.ZoneDomainResource;
import io.milton.dns.utils.RecordTypes;
import io.milton.dns.utils.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNameServer
implements Service {
    private static Logger log = LoggerFactory.getLogger((String)JNameServer.class.getName());
    static final int FLAG_DNSSECOK = 1;
    static final int FLAG_SIGONLY = 2;
    DomainResourceFactory drf;
    List<InetSocketAddress> sockAddrs = new ArrayList<InetSocketAddress>();
    List<TcpListener> tcpListeners = new ArrayList<TcpListener>();
    List<UdpListener> udpListeners = new ArrayList<UdpListener>();
    private RecordTypes recordTypes = new RecordTypes();
    volatile boolean running;

    public JNameServer(DomainResourceFactory drf, InetSocketAddress ... sockAddrs) {
        this.drf = drf;
        if (sockAddrs == null) {
            this.sockAddrs.add(new InetSocketAddress(53));
        } else {
            this.sockAddrs.addAll(Arrays.asList(sockAddrs));
        }
    }

    public void start() {
        log.info("Starting DNS server");
        this.running = true;
        for (InetSocketAddress sockAddr : this.sockAddrs) {
            log.info("Listening on interface: " + sockAddr);
            TcpListener tl = new TcpListener(sockAddr);
            this.tcpListeners.add(tl);
            new Thread(tl).start();
            UdpListener ul = new UdpListener(sockAddr);
            this.udpListeners.add(ul);
            new Thread(ul).start();
        }
        System.out.println("started server");
    }

    public void stop() {
        this.running = false;
        for (TcpListener tl : this.tcpListeners) {
            tl.close();
        }
        for (UdpListener ul : this.udpListeners) {
            ul.close();
        }
    }

    private void addRRset(Name name, Message response, RRset rrset, int section, int flags) {
        Record r;
        for (int s = 1; s <= section; ++s) {
            if (!response.findRRset(name, rrset.getType(), s)) continue;
            return;
        }
        if ((flags & 2) == 0) {
            Iterator it = rrset.rrs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
        if ((flags & 3) != 0) {
            Iterator it = rrset.sigs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
    }

    private void addSOA(Message response, SOARecord soaRecord) {
        response.addRecord(soaRecord, 2);
    }

    private void addNS(Message response, RRset nsRecords, int flags) {
        this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
    }

    private void addGlue(Message response, Name name, int flags) {
        Name domainName;
        DomainResource dr = this.getDomainResource(name.toString());
        if (dr == null) {
            return;
        }
        try {
            domainName = Utils.stringToName(dr.getName());
        }
        catch (TextParseException ex) {
            throw new RuntimeException(ex);
        }
        RRset a = this.getRRset(domainName, dr, 1, 1);
        if (a == null) {
            return;
        }
        this.addRRset(name, response, a, 3, flags);
    }

    private void addAdditional2(Message response, int section, int flags) {
        Record[] records = response.getSectionArray(section);
        for (int i = 0; i < records.length; ++i) {
            Record r = records[i];
            Name glueName = r.getAdditionalName();
            if (glueName == null) continue;
            this.addGlue(response, glueName, flags);
        }
    }

    private void addAdditional(Message response, int flags) {
        this.addAdditional2(response, 1, flags);
        this.addAdditional2(response, 2, flags);
    }

    private byte addAnswer(Message response, Name name, int type, int dclass, int iterations, int flags) {
        Name domainName;
        System.out.println("addAnswer: " + name + " type=" + type + " class=" + dclass);
        byte rcode = 0;
        if (iterations > 6) {
            log.warn("iterations too high");
            return 0;
        }
        if (type == 24 || type == 46) {
            type = 255;
            flags |= 2;
        }
        SetResponse sr = this.generateSetResponse(name, type);
        ZoneDomainResource zdr = this.findBestZone(this.drf, name);
        if (sr.isUnknown()) {
            // empty if block
        }
        try {
            domainName = Utils.stringToName(zdr.getName());
        }
        catch (TextParseException ex) {
            System.out.println("parse ex");
            throw new RuntimeException(ex);
        }
        if (sr.isNXDOMAIN()) {
            log.info("is NX domain");
            response.getHeader().setRcode(3);
            if (zdr != null) {
                RRset rrSet = this.getRRset(domainName, (DomainResource)zdr, 6, 1);
                if (rrSet != null) {
                    this.addSOA(response, (SOARecord)rrSet.first());
                }
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
            rcode = 3;
        } else if (sr.isNXRRSET()) {
            log.info("isNXRRSET");
            if (zdr != null) {
                RRset rrSet = this.getRRset(domainName, (DomainResource)zdr, 6, 1);
                if (rrSet != null) {
                    this.addSOA(response, (SOARecord)rrSet.first());
                }
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
        } else if (sr.isDelegation()) {
            log.info("delegation");
            RRset nsRecords = sr.getNS();
            this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
        } else if (sr.isCNAME()) {
            log.info("isCNAME");
            CNAMERecord cname = sr.getCNAME();
            RRset rrset = new RRset(cname);
            this.addRRset(name, response, rrset, 1, flags);
            if (zdr != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, cname.getTarget(), type, dclass, iterations + 1, flags);
        } else if (sr.isDNAME()) {
            Name newname;
            log.info("isDNAME");
            DNAMERecord dname = sr.getDNAME();
            RRset rrset = new RRset(dname);
            this.addRRset(name, response, rrset, 1, flags);
            try {
                newname = name.fromDNAME(dname);
            }
            catch (NameTooLongException e) {
                return 6;
            }
            rrset = new RRset(new CNAMERecord(name, dclass, 0L, newname));
            this.addRRset(name, response, rrset, 1, flags);
            if (zdr != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, newname, type, dclass, iterations + 1, flags);
        } else if (sr.isSuccessful()) {
            RRset[] rrsets = sr.answers();
            for (int i = 0; i < rrsets.length; ++i) {
                this.addRRset(name, response, rrsets[i], 1, flags);
            }
            if (zdr != null) {
                RRset rrSet = this.getRRset(domainName, (DomainResource)zdr, 2, 1);
                this.addNS(response, rrSet, flags);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
        }
        log.info(" = " + rcode);
        return rcode;
    }

    private SetResponse generateSetResponse(Name name, int type) {
        RRset rrset;
        Name tname;
        DomainResource dr = null;
        Name origin = new Name(name, name.labels());
        int olabels = origin.labels();
        int labels = name.labels();
        for (int tlabels = olabels; tlabels <= labels; ++tlabels) {
            RRset ns;
            Name domainName;
            boolean isExact;
            boolean isOrigin = tlabels == olabels;
            boolean bl = isExact = tlabels == labels;
            tname = isOrigin ? origin : (isExact ? name : new Name(name, labels - tlabels));
            dr = this.getDomainResource(tname.toString());
            if (dr == null) continue;
            try {
                domainName = Utils.stringToName(dr.getName());
            }
            catch (TextParseException ex) {
                throw new RuntimeException(ex);
            }
            if (!(dr instanceof ZoneDomainResource) && (ns = this.getRRset(domainName, dr, 2, 1)) != null) {
                return new SetResponse(3, ns);
            }
            if (isExact && type == 255) {
                SetResponse sr = new SetResponse(6);
                RRset[] sets = this.getAllRRsets(domainName, dr, 1);
                for (int i = 0; i < sets.length; ++i) {
                    sr.addRRset(sets[i]);
                }
                return sr;
            }
            if (isExact) {
                rrset = this.getRRset(domainName, dr, type, 1);
                if (rrset != null) {
                    SetResponse sr = new SetResponse(6);
                    sr.addRRset(rrset);
                    return sr;
                }
                rrset = this.getRRset(domainName, dr, 5, 1);
                if (rrset != null) {
                    return new SetResponse(4, rrset);
                }
            } else {
                rrset = this.getRRset(domainName, dr, 39, 1);
                if (rrset != null) {
                    return new SetResponse(5, rrset);
                }
            }
            if (!isExact) continue;
            return SetResponse.ofType(2);
        }
        for (int i = 0; i < labels - 1; ++i) {
            Name domainName;
            tname = name.wild(i + 1);
            dr = this.getDomainResource(tname.toString());
            if (dr == null) continue;
            try {
                domainName = Utils.stringToName(dr.getName());
            }
            catch (TextParseException ex) {
                throw new RuntimeException(ex);
            }
            rrset = this.getRRset(domainName, dr, type, 1);
            if (rrset == null) continue;
            SetResponse sr = new SetResponse(6);
            sr.addRRset(rrset);
            return sr;
        }
        return SetResponse.ofType(1);
    }

    byte[] generateReply(Message query, byte[] in, int length, Socket s) throws IOException {
        int flags = 0;
        Header header = query.getHeader();
        if (header.getFlag(0)) {
            return null;
        }
        if (header.getRcode() != 0) {
            return this.errorMessage(query, 1);
        }
        if (header.getOpcode() != 0) {
            return this.errorMessage(query, 4);
        }
        Record queryRecord = query.getQuestion();
        TSIGRecord queryTSIG = query.getTSIG();
        TSIG tsig = null;
        if (queryTSIG != null) {
            return this.formerrMessage(in);
        }
        OPTRecord queryOPT = query.getOPT();
        if (queryOPT != null && queryOPT.getVersion() > 0) {
            boolean bl = true;
        }
        int maxLength = s != null ? 65535 : (queryOPT != null ? Math.max(queryOPT.getPayloadSize(), 512) : 512);
        if (queryOPT != null && (queryOPT.getFlags() & 0x8000) != 0) {
            flags = 1;
        }
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(0);
        if (query.getHeader().getFlag(7)) {
            response.getHeader().setFlag(7);
        }
        response.addRecord(queryRecord, 0);
        Name name = queryRecord.getName();
        int type = queryRecord.getType();
        int dclass = queryRecord.getDClass();
        if (type == 252 && s != null) {
            return this.doAXFR(name, query, tsig, queryTSIG, s);
        }
        if (!Type.isRR(type) && type != 255) {
            return this.errorMessage(query, 4);
        }
        byte rcode = this.addAnswer(response, name, type, dclass, 0, flags);
        if (rcode != 0 && rcode != 3) {
            return this.errorMessage(query, rcode);
        }
        this.addAdditional(response, flags);
        if (queryOPT != null) {
            int optflags = flags == 1 ? 32768 : 0;
            OPTRecord opt = new OPTRecord(4096, (int)rcode, 0, optflags);
            response.addRecord(opt, 3);
        }
        response.setTSIG(tsig, 0, queryTSIG);
        return response.toWire(maxLength);
    }

    byte[] buildErrorMessage(Header header, int rcode, Record question) {
        Message response = new Message();
        response.setHeader(header);
        for (int i = 0; i < 4; ++i) {
            response.removeAllRecords(i);
        }
        if (rcode == 2) {
            response.addRecord(question, 0);
        }
        header.setRcode(rcode);
        return response.toWire();
    }

    byte[] doAXFR(Name name, Message query, TSIG tsig, TSIGRecord qtsig, Socket s) {
        return this.errorMessage(query, 5);
    }

    public byte[] formerrMessage(byte[] in) {
        Header header;
        try {
            header = new Header(in);
        }
        catch (IOException e) {
            return null;
        }
        return this.buildErrorMessage(header, 1, null);
    }

    public byte[] errorMessage(Message query, int rcode) {
        return this.buildErrorMessage(query.getHeader(), rcode, query.getQuestion());
    }

    private DomainResource getDomainResource(String domainName) {
        if (domainName.endsWith(".")) {
            domainName = domainName.substring(0, domainName.length() - 1);
        }
        try {
            return this.drf.getDomainResource(domainName);
        }
        catch (NonAuthoritativeException e) {
            return null;
        }
    }

    private RRset getRRset(Name domainName, DomainResource dr, int type, int dclass) {
        if (dr == null) {
            return null;
        }
        List allRecords = dr.getRecords();
        if (allRecords == null || allRecords.isEmpty()) {
            return null;
        }
        try {
            RRset rrset = new RRset();
            boolean empty = true;
            for (DomainResourceRecord dnsRec : allRecords) {
                Record rr;
                System.out.println("check: " + dnsRec.getClass());
                try {
                    rr = this.recordTypes.map(domainName, dnsRec);
                }
                catch (TextParseException ex) {
                    throw new RuntimeException(ex);
                }
                if (rr.getType() != type || rr.getDClass() != dclass) continue;
                rrset.addRR(rr);
                empty = false;
            }
            if (empty) {
                return null;
            }
            return rrset;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private RRset[] getAllRRsets(Name domainName, DomainResource dr, int dclass) {
        if (dr == null) {
            return null;
        }
        ArrayList<RRset> rrSets = new ArrayList<RRset>();
        List allRecords = dr.getRecords();
        for (DomainResourceRecord dnsRec : allRecords) {
            Record rr;
            try {
                rr = this.recordTypes.map(domainName, dnsRec);
            }
            catch (TextParseException ex) {
                throw new RuntimeException(ex);
            }
            boolean added = false;
            for (RRset rrSet : rrSets) {
                if (rrSet.getType() != rr.getType() || rrSet.getDClass() != rr.getDClass()) continue;
                rrSet.addRR(rr);
                added = true;
                break;
            }
            if (added) continue;
            RRset rrSet = new RRset();
            rrSet.addRR(rr);
            rrSets.add(rrSet);
        }
        RRset[] rrSetArray = new RRset[rrSets.size()];
        return rrSets.toArray(rrSetArray);
    }

    public ZoneDomainResource findBestZone(DomainResourceFactory drf, Name name) {
        ZoneDomainResource zdr = null;
        for (int tlabels = name.labels(); tlabels > 0; --tlabels) {
            Name tname = new Name(name, name.labels() - tlabels);
            DomainResource dr = this.getDomainResource(Utils.nameToString(tname));
            if (dr == null || !(dr instanceof ZoneDomainResource)) continue;
            zdr = (ZoneDomainResource)dr;
            break;
        }
        return zdr;
    }

    private String addrport(InetAddress addr, int port) {
        return addr.getHostAddress() + "#" + port;
    }

    class UdpListener
    implements Runnable {
        DatagramSocket sock;
        InetAddress addr;
        int port;

        UdpListener(InetSocketAddress sa) {
            this.addr = sa.getAddress();
            this.port = sa.getPort();
        }

        @Override
        public void run() {
            this.serveUDP(this.addr, this.port);
        }

        public void close() {
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void serveUDP(InetAddress addr, int port) {
            try {
                DatagramSocket sock = new DatagramSocket(port, addr);
                int udpLength = 512;
                byte[] in = new byte[512];
                DatagramPacket indp = new DatagramPacket(in, in.length);
                DatagramPacket outdp = null;
                while (JNameServer.this.running) {
                    indp.setLength(in.length);
                    try {
                        sock.receive(indp);
                    }
                    catch (InterruptedIOException e) {
                        continue;
                    }
                    Message query = null;
                    byte[] response = null;
                    try {
                        query = new Message(in);
                        response = JNameServer.this.generateReply(query, in, indp.getLength(), null);
                        if (response == null) {
                            continue;
                        }
                    }
                    catch (IOException e) {
                        log.error("Exeption generating DNS response", (Throwable)e);
                        response = JNameServer.this.formerrMessage(in);
                    }
                    catch (RuntimeException e) {
                        log.error("Exeption generating DNS response", (Throwable)e);
                        response = query != null ? JNameServer.this.errorMessage(query, 2) : JNameServer.this.formerrMessage(in);
                    }
                    if (outdp == null) {
                        outdp = new DatagramPacket(response, response.length, indp.getAddress(), indp.getPort());
                    } else {
                        outdp.setData(response);
                        outdp.setLength(response.length);
                        outdp.setAddress(indp.getAddress());
                        outdp.setPort(indp.getPort());
                    }
                    sock.send(outdp);
                }
            }
            catch (IOException e) {
                System.out.println("serveUDP(" + JNameServer.this.addrport(addr, port) + "): " + e);
            }
        }
    }

    class TcpListener
    implements Runnable {
        InetAddress addr;
        int port;
        ServerSocket sock;

        TcpListener(InetSocketAddress sa) {
            this.addr = sa.getAddress();
            this.port = sa.getPort();
        }

        @Override
        public void run() {
            this.serveTCP(this.addr, this.port);
        }

        public void close() {
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void TCPclient(Socket s) {
            try {
                InputStream is = s.getInputStream();
                DataInputStream dataIn = new DataInputStream(is);
                int inLength = dataIn.readUnsignedShort();
                byte[] in = new byte[inLength];
                dataIn.readFully(in);
                Message query = null;
                byte[] response = null;
                try {
                    query = new Message(in);
                    response = JNameServer.this.generateReply(query, in, in.length, s);
                    if (response == null) {
                        return;
                    }
                }
                catch (IOException e) {
                    log.error("exception", (Throwable)e);
                    response = JNameServer.this.formerrMessage(in);
                }
                catch (RuntimeException e) {
                    log.error("exception", (Throwable)e);
                    response = query != null ? JNameServer.this.errorMessage(query, 2) : JNameServer.this.formerrMessage(in);
                }
                DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
                dataOut.writeShort(response.length);
                dataOut.write(response);
                return;
            }
            catch (IOException e) {
                System.out.println("TCPclient(" + JNameServer.this.addrport(s.getLocalAddress(), s.getLocalPort()) + "): " + e);
                try {
                    s.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
            finally {
                try {
                    s.close();
                }
                catch (IOException e) {}
            }
        }

        public void serveTCP(InetAddress addr, int port) {
            try {
                this.sock = new ServerSocket(port, 128, addr);
                while (JNameServer.this.running) {
                    final Socket s = this.sock.accept();
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            TcpListener.this.TCPclient(s);
                        }
                    });
                    t.start();
                }
            }
            catch (IOException e) {
                System.out.println("serveTCP(" + JNameServer.this.addrport(addr, port) + "): " + e);
            }
        }
    }
}

