/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.Name;
import io.milton.dns.TextParseException;
import io.milton.dns.record.Compression;
import io.milton.dns.record.DNSInput;
import io.milton.dns.record.DNSOutput;
import io.milton.dns.record.Record;
import io.milton.dns.record.Tokenizer;
import io.milton.dns.record.WireParseException;
import java.io.IOException;

public class GPOSRecord
extends Record {
    private static final long serialVersionUID = -6349714958085750705L;
    private byte[] latitude;
    private byte[] longitude;
    private byte[] altitude;

    GPOSRecord() {
    }

    @Override
    Record getObject() {
        return new GPOSRecord();
    }

    private void validate(double longitude, double latitude) throws IllegalArgumentException {
        if (longitude < -90.0 || longitude > 90.0) {
            throw new IllegalArgumentException("illegal longitude " + longitude);
        }
        if (latitude < -180.0 || latitude > 180.0) {
            throw new IllegalArgumentException("illegal latitude " + latitude);
        }
    }

    public GPOSRecord(Name name, int dclass, long ttl, double longitude, double latitude, double altitude) {
        super(name, 27, dclass, ttl);
        this.validate(longitude, latitude);
        this.longitude = Double.toString(longitude).getBytes();
        this.latitude = Double.toString(latitude).getBytes();
        this.altitude = Double.toString(altitude).getBytes();
    }

    public GPOSRecord(Name name, int dclass, long ttl, String longitude, String latitude, String altitude) {
        super(name, 27, dclass, ttl);
        try {
            this.longitude = GPOSRecord.byteArrayFromString(longitude);
            this.latitude = GPOSRecord.byteArrayFromString(latitude);
            this.validate(this.getLongitude(), this.getLatitude());
            this.altitude = GPOSRecord.byteArrayFromString(altitude);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.longitude = in.readCountedString();
        this.latitude = in.readCountedString();
        this.altitude = in.readCountedString();
        try {
            this.validate(this.getLongitude(), this.getLatitude());
        }
        catch (IllegalArgumentException e) {
            throw new WireParseException(e.getMessage());
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        try {
            this.longitude = GPOSRecord.byteArrayFromString(st.getString());
            this.latitude = GPOSRecord.byteArrayFromString(st.getString());
            this.altitude = GPOSRecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
        try {
            this.validate(this.getLongitude(), this.getLatitude());
        }
        catch (IllegalArgumentException e) {
            throw new WireParseException(e.getMessage());
        }
    }

    @Override
    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(GPOSRecord.byteArrayToString(this.longitude, true));
        sb.append(" ");
        sb.append(GPOSRecord.byteArrayToString(this.latitude, true));
        sb.append(" ");
        sb.append(GPOSRecord.byteArrayToString(this.altitude, true));
        return sb.toString();
    }

    public String getLongitudeString() {
        return GPOSRecord.byteArrayToString(this.longitude, false);
    }

    public double getLongitude() {
        return Double.parseDouble(this.getLongitudeString());
    }

    public String getLatitudeString() {
        return GPOSRecord.byteArrayToString(this.latitude, false);
    }

    public double getLatitude() {
        return Double.parseDouble(this.getLatitudeString());
    }

    public String getAltitudeString() {
        return GPOSRecord.byteArrayToString(this.altitude, false);
    }

    public double getAltitude() {
        return Double.parseDouble(this.getAltitudeString());
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeCountedString(this.longitude);
        out.writeCountedString(this.latitude);
        out.writeCountedString(this.altitude);
    }
}

