/*
 * Decompiled with CFR 0.152.
 */
package io.milton.config;

import io.milton.common.Stoppable;
import io.milton.config.InitListener;
import io.milton.event.EventManager;
import io.milton.event.EventManagerImpl;
import io.milton.http.AuthenticationHandler;
import io.milton.http.AuthenticationService;
import io.milton.http.CompressingResponseHandler;
import io.milton.http.Filter;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpExtension;
import io.milton.http.HttpManager;
import io.milton.http.ProtocolHandlers;
import io.milton.http.ResourceFactory;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.SecurityManager;
import io.milton.http.StandardFilter;
import io.milton.http.UrlAdapter;
import io.milton.http.UrlAdapterImpl;
import io.milton.http.entity.DefaultEntityTransport;
import io.milton.http.entity.EntityTransport;
import io.milton.http.fck.FckResourceFactory;
import io.milton.http.fs.FileContentService;
import io.milton.http.fs.FileSystemResourceFactory;
import io.milton.http.fs.SimpleFileContentService;
import io.milton.http.fs.SimpleSecurityManager;
import io.milton.http.http11.CacheControlHelper;
import io.milton.http.http11.ContentGenerator;
import io.milton.http.http11.DefaultCacheControlHelper;
import io.milton.http.http11.DefaultETagGenerator;
import io.milton.http.http11.DefaultHttp11ResponseHandler;
import io.milton.http.http11.ETagGenerator;
import io.milton.http.http11.Http11Protocol;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.http11.MatchHelper;
import io.milton.http.http11.PartialGetHelper;
import io.milton.http.http11.SimpleContentGenerator;
import io.milton.http.http11.auth.BasicAuthHandler;
import io.milton.http.http11.auth.CookieAuthenticationHandler;
import io.milton.http.http11.auth.DigestAuthenticationHandler;
import io.milton.http.http11.auth.ExpiredNonceRemover;
import io.milton.http.http11.auth.FormAuthenticationHandler;
import io.milton.http.http11.auth.LoginResponseHandler;
import io.milton.http.http11.auth.Nonce;
import io.milton.http.http11.auth.NonceProvider;
import io.milton.http.http11.auth.SimpleMemoryNonceProvider;
import io.milton.http.json.JsonResourceFactory;
import io.milton.http.quota.QuotaDataAccessor;
import io.milton.http.values.ValueWriters;
import io.milton.http.webdav.DefaultUserAgentHelper;
import io.milton.http.webdav.DefaultWebDavResponseHandler;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropPatchSetter;
import io.milton.http.webdav.PropertySourcePatchSetter;
import io.milton.http.webdav.ResourceTypeHelper;
import io.milton.http.webdav.UserAgentHelper;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.http.webdav.WebDavResourceTypeHelper;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.property.BeanPropertyAuthoriser;
import io.milton.property.BeanPropertySource;
import io.milton.property.DefaultPropertyAuthoriser;
import io.milton.property.MultiNamespaceCustomPropertySource;
import io.milton.property.PropertyAuthoriser;
import io.milton.property.PropertySource;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpManagerBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpManagerBuilder.class);
    protected List<InitListener> listeners;
    protected ResourceFactory mainResourceFactory;
    protected ResourceFactory outerResourceFactory;
    protected FileContentService fileContentService = new SimpleFileContentService();
    protected DefaultHttp11ResponseHandler.BUFFERING buffering;
    protected List<AuthenticationHandler> authenticationHandlers;
    protected List<AuthenticationHandler> cookieDelegateHandlers;
    protected DigestAuthenticationHandler digestHandler;
    protected BasicAuthHandler basicHandler;
    protected CookieAuthenticationHandler cookieAuthenticationHandler;
    protected FormAuthenticationHandler formAuthenticationHandler;
    protected Map<UUID, Nonce> nonces = new ConcurrentHashMap<UUID, Nonce>();
    protected int nonceValiditySeconds = 86400;
    protected NonceProvider nonceProvider;
    protected AuthenticationService authenticationService;
    protected ExpiredNonceRemover expiredNonceRemover;
    protected List<Stoppable> shutdownHandlers = new CopyOnWriteArrayList<Stoppable>();
    protected ResourceTypeHelper resourceTypeHelper;
    protected WebDavResponseHandler webdavResponseHandler;
    protected WebDavResponseHandler outerWebdavResponseHandler;
    protected ContentGenerator contentGenerator = new SimpleContentGenerator();
    protected CacheControlHelper cacheControlHelper = new DefaultCacheControlHelper();
    protected HandlerHelper handlerHelper;
    protected ArrayList<HttpExtension> protocols;
    protected ProtocolHandlers protocolHandlers;
    protected EntityTransport entityTransport = new DefaultEntityTransport();
    protected EventManager eventManager = new EventManagerImpl();
    protected PropertyAuthoriser propertyAuthoriser;
    protected List<PropertySource> propertySources;
    protected List<PropertySource> extraPropertySources;
    protected ETagGenerator eTagGenerator = new DefaultETagGenerator();
    protected Http11ResponseHandler http11ResponseHandler;
    protected ValueWriters valueWriters = new ValueWriters();
    protected PropFindXmlGenerator propFindXmlGenerator;
    protected List<Filter> filters;
    protected Filter defaultStandardFilter = new StandardFilter();
    protected UrlAdapter urlAdapter = new UrlAdapterImpl();
    protected QuotaDataAccessor quotaDataAccessor;
    protected PropPatchSetter propPatchSetter;
    protected boolean enableOptionsAuth = false;
    protected ResourceHandlerHelper resourceHandlerHelper;
    protected boolean initDone;
    protected boolean enableCompression = true;
    protected boolean enabledJson = true;
    protected boolean enableBasicAuth = true;
    protected boolean enableDigestAuth = true;
    protected boolean enableFormAuth = true;
    protected boolean enableCookieAuth = true;
    protected boolean enabledCkBrowser = false;
    protected String loginPage = "/login.html";
    protected List<String> loginPageExcludePaths;
    protected File rootDir = null;
    protected SecurityManager securityManager;
    protected String fsContextPath;
    protected String fsRealm = "milton";
    protected Map<String, String> mapOfNameAndPasswords;
    protected String defaultUser = "user";
    protected String defaultPassword = "password";
    protected UserAgentHelper userAgentHelper;
    protected MultiNamespaceCustomPropertySource multiNamespaceCustomPropertySource;
    protected boolean multiNamespaceCustomPropertySourceEnabled = true;
    protected BeanPropertySource beanPropertySource;
    protected WebDavProtocol webDavProtocol;
    protected boolean webdavEnabled = true;
    protected MatchHelper matchHelper;
    protected PartialGetHelper partialGetHelper;
    protected LoginResponseHandler loginResponseHandler;
    protected LoginResponseHandler.LoginPageTypeHandler loginPageTypeHandler = new LoginResponseHandler.ContentTypeLoginPageTypeHandler();
    protected boolean enableExpectContinue = true;

    public final void init() {
        if (this.listeners != null) {
            for (InitListener l : this.listeners) {
                l.beforeInit(this);
            }
        }
        if (this.mainResourceFactory == null) {
            this.rootDir = new File(System.getProperty("user.home"));
            if (!this.rootDir.exists() || !this.rootDir.isDirectory()) {
                throw new RuntimeException("Root directory is not valie: " + this.rootDir.getAbsolutePath());
            }
            if (this.securityManager == null) {
                if (this.mapOfNameAndPasswords == null) {
                    this.mapOfNameAndPasswords = new HashMap<String, String>();
                    this.mapOfNameAndPasswords.put(this.defaultUser, this.defaultPassword);
                    log.info("Configuring default user and password: " + this.defaultUser + "/" + this.defaultPassword);
                }
                this.securityManager = new SimpleSecurityManager(this.fsRealm, this.mapOfNameAndPasswords);
            }
            log.info("Using securityManager: " + this.securityManager.getClass());
            FileSystemResourceFactory fsResourceFactory = new FileSystemResourceFactory(this.rootDir, this.securityManager, this.fsContextPath);
            fsResourceFactory.setContentService(this.fileContentService);
            this.mainResourceFactory = fsResourceFactory;
            log.info("Using file system with root directory: " + this.rootDir.getAbsolutePath());
        }
        log.info("Using mainResourceFactory: " + this.mainResourceFactory.getClass());
        if (this.authenticationService == null) {
            if (this.authenticationHandlers == null) {
                this.authenticationHandlers = new ArrayList<AuthenticationHandler>();
                if (this.basicHandler == null && this.enableBasicAuth) {
                    this.basicHandler = new BasicAuthHandler();
                }
                if (this.basicHandler != null) {
                    this.authenticationHandlers.add(this.basicHandler);
                }
                if (this.digestHandler == null && this.enableDigestAuth) {
                    if (this.nonceProvider == null) {
                        if (this.expiredNonceRemover == null) {
                            this.expiredNonceRemover = new ExpiredNonceRemover(this.nonces, this.nonceValiditySeconds);
                            this.showLog("expiredNonceRemover", this.expiredNonceRemover);
                        }
                        this.nonceProvider = new SimpleMemoryNonceProvider(this.nonceValiditySeconds, this.expiredNonceRemover, this.nonces);
                        this.showLog("nonceProvider", this.nonceProvider);
                    }
                    this.digestHandler = new DigestAuthenticationHandler(this.nonceProvider);
                }
                if (this.digestHandler != null) {
                    this.authenticationHandlers.add(this.digestHandler);
                }
                if (this.formAuthenticationHandler == null && this.enableFormAuth) {
                    this.formAuthenticationHandler = new FormAuthenticationHandler();
                }
                if (this.formAuthenticationHandler != null) {
                    this.authenticationHandlers.add(this.formAuthenticationHandler);
                }
                if (this.cookieAuthenticationHandler == null && this.enableCookieAuth) {
                    if (this.cookieDelegateHandlers == null) {
                        this.cookieDelegateHandlers = new ArrayList<AuthenticationHandler>();
                        if (this.basicHandler != null) {
                            this.cookieDelegateHandlers.add(this.basicHandler);
                            this.authenticationHandlers.remove(this.basicHandler);
                        }
                        if (this.formAuthenticationHandler != null) {
                            this.cookieDelegateHandlers.add(this.formAuthenticationHandler);
                            this.authenticationHandlers.remove(this.formAuthenticationHandler);
                        }
                    }
                    this.cookieAuthenticationHandler = new CookieAuthenticationHandler(this.cookieDelegateHandlers, this.mainResourceFactory);
                    this.authenticationHandlers.add(this.cookieAuthenticationHandler);
                }
            }
            this.authenticationService = new AuthenticationService(this.authenticationHandlers);
            this.showLog("authenticationService", this.authenticationService);
        }
        this.init(this.authenticationService);
    }

    private void init(AuthenticationService authenticationService) {
        if (this.resourceTypeHelper == null) {
            this.buildResourceTypeHelper();
        }
        if (this.propFindXmlGenerator == null) {
            this.propFindXmlGenerator = new PropFindXmlGenerator(this.valueWriters);
            this.showLog("propFindXmlGenerator", this.propFindXmlGenerator);
        }
        if (this.http11ResponseHandler == null) {
            DefaultHttp11ResponseHandler rh = this.createDefaultHttp11ResponseHandler(authenticationService);
            rh.setContentGenerator(this.contentGenerator);
            rh.setCacheControlHelper(this.cacheControlHelper);
            rh.setBuffering(this.buffering);
            this.http11ResponseHandler = rh;
            this.showLog("http11ResponseHandler", this.http11ResponseHandler);
        }
        if (this.webdavResponseHandler == null) {
            this.webdavResponseHandler = new DefaultWebDavResponseHandler(this.http11ResponseHandler, this.resourceTypeHelper, this.propFindXmlGenerator);
        }
        this.outerWebdavResponseHandler = this.webdavResponseHandler;
        if (this.enableCompression) {
            CompressingResponseHandler compressingResponseHandler = new CompressingResponseHandler(this.webdavResponseHandler);
            compressingResponseHandler.setBuffering(this.buffering);
            this.outerWebdavResponseHandler = compressingResponseHandler;
            this.showLog("webdavResponseHandler", this.webdavResponseHandler);
        }
        if (this.enableFormAuth) {
            log.info("form authentication is enabled, so wrap response handler with " + LoginResponseHandler.class);
            if (this.loginResponseHandler == null) {
                this.loginResponseHandler = new LoginResponseHandler(this.outerWebdavResponseHandler, this.mainResourceFactory, this.loginPageTypeHandler);
                this.loginResponseHandler.setExcludePaths(this.loginPageExcludePaths);
                this.loginResponseHandler.setLoginPage(this.loginPage);
                this.outerWebdavResponseHandler = this.loginResponseHandler;
            }
        }
        this.init(authenticationService, this.outerWebdavResponseHandler, this.resourceTypeHelper);
    }

    private void init(AuthenticationService authenticationService, WebDavResponseHandler webdavResponseHandler, ResourceTypeHelper resourceTypeHelper) {
        this.initDone = true;
        if (this.handlerHelper == null) {
            this.handlerHelper = new HandlerHelper(authenticationService);
            this.showLog("handlerHelper", this.handlerHelper);
        }
        this.handlerHelper.setEnableExpectContinue(this.enableExpectContinue);
        if (this.resourceHandlerHelper == null) {
            this.resourceHandlerHelper = new ResourceHandlerHelper(this.handlerHelper, this.urlAdapter, webdavResponseHandler);
            this.showLog("resourceHandlerHelper", this.resourceHandlerHelper);
        }
        this.buildProtocolHandlers(webdavResponseHandler, resourceTypeHelper);
        this.buildOuterResourceFactory();
        this.filters = this.filters != null ? new ArrayList<Filter>(this.filters) : new ArrayList<Filter>();
        this.filters.add(this.defaultStandardFilter);
    }

    public HttpManager buildHttpManager() {
        if (!this.initDone) {
            this.init();
        }
        if (this.listeners != null) {
            for (InitListener l : this.listeners) {
                l.afterInit(this);
            }
        }
        HttpManager httpManager = new HttpManager(this.outerResourceFactory, this.webdavResponseHandler, this.protocolHandlers, this.entityTransport, this.filters, this.eventManager, this.shutdownHandlers);
        if (this.listeners != null) {
            for (InitListener l : this.listeners) {
                l.afterBuild(this, httpManager);
            }
        }
        if (this.expiredNonceRemover != null) {
            this.shutdownHandlers.add((Stoppable)this.expiredNonceRemover);
            log.info("Starting " + this.expiredNonceRemover + " this will remove Digest nonces from memory when they expire");
            this.expiredNonceRemover.start();
        }
        return httpManager;
    }

    protected PropertyAuthoriser initPropertyAuthoriser() {
        if (this.propertyAuthoriser == null) {
            this.propertyAuthoriser = new DefaultPropertyAuthoriser();
            if (this.beanPropertySource != null) {
                this.propertyAuthoriser = new BeanPropertyAuthoriser(this.beanPropertySource, this.propertyAuthoriser);
            }
        }
        return this.propertyAuthoriser;
    }

    protected List<PropertySource> initDefaultPropertySources(ResourceTypeHelper resourceTypeHelper) {
        ArrayList<PropertySource> list = new ArrayList<PropertySource>();
        if (this.multiNamespaceCustomPropertySource == null && this.multiNamespaceCustomPropertySourceEnabled) {
            this.multiNamespaceCustomPropertySource = new MultiNamespaceCustomPropertySource();
        }
        if (this.multiNamespaceCustomPropertySource != null) {
            list.add(this.multiNamespaceCustomPropertySource);
        }
        if (this.initBeanPropertySource() != null) {
            list.add(this.beanPropertySource);
        }
        return list;
    }

    protected BeanPropertySource initBeanPropertySource() {
        if (this.beanPropertySource == null) {
            this.beanPropertySource = new BeanPropertySource();
        }
        return this.beanPropertySource;
    }

    protected DefaultHttp11ResponseHandler createDefaultHttp11ResponseHandler(AuthenticationService authenticationService) {
        DefaultHttp11ResponseHandler rh = new DefaultHttp11ResponseHandler(authenticationService, this.eTagGenerator);
        return rh;
    }

    protected void buildResourceTypeHelper() {
        WebDavResourceTypeHelper webDavResourceTypeHelper = new WebDavResourceTypeHelper();
        this.resourceTypeHelper = webDavResourceTypeHelper;
        this.showLog("resourceTypeHelper", this.resourceTypeHelper);
    }

    protected void buildProtocolHandlers(WebDavResponseHandler webdavResponseHandler, ResourceTypeHelper resourceTypeHelper) {
        if (this.protocols == null) {
            this.protocols = new ArrayList();
            if (this.matchHelper == null) {
                this.matchHelper = new MatchHelper(this.eTagGenerator);
            }
            if (this.partialGetHelper == null) {
                this.partialGetHelper = new PartialGetHelper(webdavResponseHandler);
            }
            Http11Protocol http11Protocol = new Http11Protocol(webdavResponseHandler, this.handlerHelper, this.resourceHandlerHelper, this.enableOptionsAuth, this.matchHelper, this.partialGetHelper);
            this.protocols.add(http11Protocol);
            if (this.propertySources == null) {
                this.propertySources = this.initDefaultPropertySources(resourceTypeHelper);
                this.showLog("propertySources", this.propertySources);
            }
            if (this.extraPropertySources != null) {
                for (PropertySource ps : this.extraPropertySources) {
                    log.info("Add extra property source: " + ps.getClass());
                    this.propertySources.add(ps);
                }
            }
            if (this.propPatchSetter == null) {
                this.propPatchSetter = new PropertySourcePatchSetter(this.propertySources);
            }
            if (this.userAgentHelper == null) {
                this.userAgentHelper = new DefaultUserAgentHelper();
            }
            if (this.webDavProtocol == null && this.webdavEnabled) {
                this.webDavProtocol = new WebDavProtocol(this.handlerHelper, resourceTypeHelper, webdavResponseHandler, this.propertySources, this.quotaDataAccessor, this.propPatchSetter, this.initPropertyAuthoriser(), this.eTagGenerator, this.urlAdapter, this.resourceHandlerHelper, this.userAgentHelper);
            }
            if (this.webDavProtocol != null) {
                this.protocols.add(this.webDavProtocol);
            }
        }
        if (this.protocolHandlers == null) {
            this.protocolHandlers = new ProtocolHandlers(this.protocols);
        }
    }

    protected void buildOuterResourceFactory() {
        if (this.outerResourceFactory == null) {
            this.outerResourceFactory = this.mainResourceFactory;
            if (this.enabledJson) {
                this.outerResourceFactory = new JsonResourceFactory(this.outerResourceFactory, this.eventManager, this.propertySources, this.propPatchSetter, this.initPropertyAuthoriser());
                log.info("Enabled json/ajax gatewayw with: " + this.outerResourceFactory.getClass());
            }
            if (this.enabledCkBrowser) {
                this.outerResourceFactory = new FckResourceFactory(this.outerResourceFactory);
                log.info("Enabled CK Editor support with: " + this.outerResourceFactory.getClass());
            }
        }
    }

    public DefaultHttp11ResponseHandler.BUFFERING getBuffering() {
        return this.buffering;
    }

    public void setBuffering(DefaultHttp11ResponseHandler.BUFFERING buffering) {
        this.buffering = buffering;
    }

    public ResourceFactory getResourceFactory() {
        return this.mainResourceFactory;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.mainResourceFactory = resourceFactory;
    }

    public List<AuthenticationHandler> getAuthenticationHandlers() {
        return this.authenticationHandlers;
    }

    public void setAuthenticationHandlers(List<AuthenticationHandler> authenticationHandlers) {
        this.authenticationHandlers = authenticationHandlers;
    }

    public Map<UUID, Nonce> getNonces() {
        return this.nonces;
    }

    public void setNonces(Map<UUID, Nonce> nonces) {
        this.nonces = nonces;
    }

    public ResourceFactory getMainResourceFactory() {
        return this.mainResourceFactory;
    }

    public void setMainResourceFactory(ResourceFactory mainResourceFactory) {
        this.mainResourceFactory = mainResourceFactory;
    }

    public ResourceFactory getOuterResourceFactory() {
        return this.outerResourceFactory;
    }

    public void setOuterResourceFactory(ResourceFactory outerResourceFactory) {
        this.outerResourceFactory = outerResourceFactory;
    }

    public int getNonceValiditySeconds() {
        return this.nonceValiditySeconds;
    }

    public void setNonceValiditySeconds(int nonceValiditySeconds) {
        this.nonceValiditySeconds = nonceValiditySeconds;
    }

    public NonceProvider getNonceProvider() {
        return this.nonceProvider;
    }

    public void setNonceProvider(NonceProvider nonceProvider) {
        this.nonceProvider = nonceProvider;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public ExpiredNonceRemover getExpiredNonceRemover() {
        return this.expiredNonceRemover;
    }

    public void setExpiredNonceRemover(ExpiredNonceRemover expiredNonceRemover) {
        this.expiredNonceRemover = expiredNonceRemover;
    }

    public List<Stoppable> getShutdownHandlers() {
        return this.shutdownHandlers;
    }

    public void setShutdownHandlers(List<Stoppable> shutdownHandlers) {
        this.shutdownHandlers = shutdownHandlers;
    }

    public ResourceTypeHelper getResourceTypeHelper() {
        return this.resourceTypeHelper;
    }

    public void setResourceTypeHelper(ResourceTypeHelper resourceTypeHelper) {
        this.resourceTypeHelper = resourceTypeHelper;
    }

    public WebDavResponseHandler getWebdavResponseHandler() {
        return this.webdavResponseHandler;
    }

    public void setWebdavResponseHandler(WebDavResponseHandler webdavResponseHandler) {
        this.webdavResponseHandler = webdavResponseHandler;
    }

    public HandlerHelper getHandlerHelper() {
        return this.handlerHelper;
    }

    public void setHandlerHelper(HandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
    }

    public ArrayList<HttpExtension> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(ArrayList<HttpExtension> protocols) {
        this.protocols = protocols;
    }

    public ProtocolHandlers getProtocolHandlers() {
        return this.protocolHandlers;
    }

    public void setProtocolHandlers(ProtocolHandlers protocolHandlers) {
        this.protocolHandlers = protocolHandlers;
    }

    public EntityTransport getEntityTransport() {
        return this.entityTransport;
    }

    public void setEntityTransport(EntityTransport entityTransport) {
        this.entityTransport = entityTransport;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public PropertyAuthoriser getPropertyAuthoriser() {
        return this.propertyAuthoriser;
    }

    public void setPropertyAuthoriser(PropertyAuthoriser propertyAuthoriser) {
        this.propertyAuthoriser = propertyAuthoriser;
    }

    public List<PropertySource> getPropertySources() {
        return this.propertySources;
    }

    public void setPropertySources(List<PropertySource> propertySources) {
        this.propertySources = propertySources;
    }

    public ETagGenerator geteTagGenerator() {
        return this.eTagGenerator;
    }

    public void seteTagGenerator(ETagGenerator eTagGenerator) {
        this.eTagGenerator = eTagGenerator;
    }

    public Http11ResponseHandler getHttp11ResponseHandler() {
        return this.http11ResponseHandler;
    }

    public void setHttp11ResponseHandler(Http11ResponseHandler http11ResponseHandler) {
        this.http11ResponseHandler = http11ResponseHandler;
    }

    public ValueWriters getValueWriters() {
        return this.valueWriters;
    }

    public void setValueWriters(ValueWriters valueWriters) {
        this.valueWriters = valueWriters;
    }

    public PropFindXmlGenerator getPropFindXmlGenerator() {
        return this.propFindXmlGenerator;
    }

    public void setPropFindXmlGenerator(PropFindXmlGenerator propFindXmlGenerator) {
        this.propFindXmlGenerator = propFindXmlGenerator;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public Filter getDefaultStandardFilter() {
        return this.defaultStandardFilter;
    }

    public void setDefaultStandardFilter(Filter defaultStandardFilter) {
        this.defaultStandardFilter = defaultStandardFilter;
    }

    public UrlAdapter getUrlAdapter() {
        return this.urlAdapter;
    }

    public void setUrlAdapter(UrlAdapter urlAdapter) {
        this.urlAdapter = urlAdapter;
    }

    public QuotaDataAccessor getQuotaDataAccessor() {
        return this.quotaDataAccessor;
    }

    public void setQuotaDataAccessor(QuotaDataAccessor quotaDataAccessor) {
        this.quotaDataAccessor = quotaDataAccessor;
    }

    public PropPatchSetter getPropPatchSetter() {
        return this.propPatchSetter;
    }

    public void setPropPatchSetter(PropPatchSetter propPatchSetter) {
        this.propPatchSetter = propPatchSetter;
    }

    public boolean isInitDone() {
        return this.initDone;
    }

    public void setInitDone(boolean initDone) {
        this.initDone = initDone;
    }

    public boolean isEnableOptionsAuth() {
        return this.enableOptionsAuth;
    }

    public void setEnableOptionsAuth(boolean enableOptionsAuth) {
        this.enableOptionsAuth = enableOptionsAuth;
    }

    public boolean isEnableCompression() {
        return this.enableCompression;
    }

    public void setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
    }

    public boolean isEnabledJson() {
        return this.enabledJson;
    }

    public void setEnabledJson(boolean enabledJson) {
        this.enabledJson = enabledJson;
    }

    public List<PropertySource> getExtraPropertySources() {
        return this.extraPropertySources;
    }

    public void setExtraPropertySources(List<PropertySource> extraPropertySources) {
        this.extraPropertySources = extraPropertySources;
    }

    protected void showLog(String propertyName, Object defaultedTo) {
        log.info("set property: " + propertyName + " to: " + defaultedTo);
    }

    public boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public void setEnableBasicAuth(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public boolean isEnableCookieAuth() {
        return this.enableCookieAuth;
    }

    public void setEnableCookieAuth(boolean enableCookieAuth) {
        this.enableCookieAuth = enableCookieAuth;
    }

    public boolean isEnableDigestAuth() {
        return this.enableDigestAuth;
    }

    public void setEnableDigestAuth(boolean enableDigestAuth) {
        this.enableDigestAuth = enableDigestAuth;
    }

    public boolean isEnableFormAuth() {
        return this.enableFormAuth;
    }

    public void setEnableFormAuth(boolean enableFormAuth) {
        this.enableFormAuth = enableFormAuth;
    }

    public BasicAuthHandler getBasicHandler() {
        return this.basicHandler;
    }

    public void setBasicHandler(BasicAuthHandler basicHandler) {
        this.basicHandler = basicHandler;
    }

    public CookieAuthenticationHandler getCookieAuthenticationHandler() {
        return this.cookieAuthenticationHandler;
    }

    public void setCookieAuthenticationHandler(CookieAuthenticationHandler cookieAuthenticationHandler) {
        this.cookieAuthenticationHandler = cookieAuthenticationHandler;
    }

    public List<AuthenticationHandler> getCookieDelegateHandlers() {
        return this.cookieDelegateHandlers;
    }

    public void setCookieDelegateHandlers(List<AuthenticationHandler> cookieDelegateHandlers) {
        this.cookieDelegateHandlers = cookieDelegateHandlers;
    }

    public DigestAuthenticationHandler getDigestHandler() {
        return this.digestHandler;
    }

    public void setDigestHandler(DigestAuthenticationHandler digestHandler) {
        this.digestHandler = digestHandler;
    }

    public FormAuthenticationHandler getFormAuthenticationHandler() {
        return this.formAuthenticationHandler;
    }

    public void setFormAuthenticationHandler(FormAuthenticationHandler formAuthenticationHandler) {
        this.formAuthenticationHandler = formAuthenticationHandler;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public List<String> getLoginPageExcludePaths() {
        return this.loginPageExcludePaths;
    }

    public void setLoginPageExcludePaths(List<String> loginPageExcludePaths) {
        this.loginPageExcludePaths = loginPageExcludePaths;
    }

    public ResourceHandlerHelper getResourceHandlerHelper() {
        return this.resourceHandlerHelper;
    }

    public void setResourceHandlerHelper(ResourceHandlerHelper resourceHandlerHelper) {
        this.resourceHandlerHelper = resourceHandlerHelper;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public String getFsContextPath() {
        return this.fsContextPath;
    }

    public void setFsContextPath(String fsContextPath) {
        this.fsContextPath = fsContextPath;
    }

    public UserAgentHelper getUserAgentHelper() {
        return this.userAgentHelper;
    }

    public void setUserAgentHelper(UserAgentHelper userAgentHelper) {
        this.userAgentHelper = userAgentHelper;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(String defaultUser) {
        this.defaultUser = defaultUser;
    }

    public String getFsRealm() {
        return this.fsRealm;
    }

    public void setFsRealm(String fsRealm) {
        this.fsRealm = fsRealm;
    }

    public Map<String, String> getMapOfNameAndPasswords() {
        return this.mapOfNameAndPasswords;
    }

    public void setMapOfNameAndPasswords(Map<String, String> mapOfNameAndPasswords) {
        this.mapOfNameAndPasswords = mapOfNameAndPasswords;
    }

    public MultiNamespaceCustomPropertySource getMultiNamespaceCustomPropertySource() {
        return this.multiNamespaceCustomPropertySource;
    }

    public void setMultiNamespaceCustomPropertySource(MultiNamespaceCustomPropertySource multiNamespaceCustomPropertySource) {
        this.multiNamespaceCustomPropertySource = multiNamespaceCustomPropertySource;
    }

    public BeanPropertySource getBeanPropertySource() {
        return this.beanPropertySource;
    }

    public void setBeanPropertySource(BeanPropertySource beanPropertySource) {
        this.beanPropertySource = beanPropertySource;
    }

    public boolean isEnabledCkBrowser() {
        return this.enabledCkBrowser;
    }

    public void setEnabledCkBrowser(boolean enabledCkBrowser) {
        this.enabledCkBrowser = enabledCkBrowser;
    }

    public WebDavProtocol getWebDavProtocol() {
        return this.webDavProtocol;
    }

    public void setWebDavProtocol(WebDavProtocol webDavProtocol) {
        this.webDavProtocol = webDavProtocol;
    }

    public boolean isWebdavEnabled() {
        return this.webdavEnabled;
    }

    public void setWebdavEnabled(boolean webdavEnabled) {
        this.webdavEnabled = webdavEnabled;
    }

    public MatchHelper getMatchHelper() {
        return this.matchHelper;
    }

    public void setMatchHelper(MatchHelper matchHelper) {
        this.matchHelper = matchHelper;
    }

    public PartialGetHelper getPartialGetHelper() {
        return this.partialGetHelper;
    }

    public void setPartialGetHelper(PartialGetHelper partialGetHelper) {
        this.partialGetHelper = partialGetHelper;
    }

    public boolean isMultiNamespaceCustomPropertySourceEnabled() {
        return this.multiNamespaceCustomPropertySourceEnabled;
    }

    public void setMultiNamespaceCustomPropertySourceEnabled(boolean multiNamespaceCustomPropertySourceEnabled) {
        this.multiNamespaceCustomPropertySourceEnabled = multiNamespaceCustomPropertySourceEnabled;
    }

    public LoginResponseHandler.LoginPageTypeHandler getLoginPageTypeHandler() {
        return this.loginPageTypeHandler;
    }

    public void setLoginPageTypeHandler(LoginResponseHandler.LoginPageTypeHandler loginPageTypeHandler) {
        this.loginPageTypeHandler = loginPageTypeHandler;
    }

    public LoginResponseHandler getLoginResponseHandler() {
        return this.loginResponseHandler;
    }

    public void setLoginResponseHandler(LoginResponseHandler loginResponseHandler) {
        this.loginResponseHandler = loginResponseHandler;
    }

    public List<InitListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<InitListener> listeners) {
        this.listeners = listeners;
    }

    public FileContentService getFileContentService() {
        return this.fileContentService;
    }

    public void setFileContentService(FileContentService fileContentService) {
        this.fileContentService = fileContentService;
    }

    public CacheControlHelper getCacheControlHelper() {
        return this.cacheControlHelper;
    }

    public void setCacheControlHelper(CacheControlHelper cacheControlHelper) {
        this.cacheControlHelper = cacheControlHelper;
    }

    public ContentGenerator getContentGenerator() {
        return this.contentGenerator;
    }

    public void setContentGenerator(ContentGenerator contentGenerator) {
        this.contentGenerator = contentGenerator;
    }

    public void setEnableExpectContinue(boolean enableExpectContinue) {
        this.enableExpectContinue = enableExpectContinue;
    }

    public boolean isEnableExpectContinue() {
        return this.enableExpectContinue;
    }

    public WebDavResponseHandler getOuterWebdavResponseHandler() {
        return this.outerWebdavResponseHandler;
    }
}

