/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.util.LazySet;
import org.glite.authz.common.model.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Resource
implements Serializable {
    private static final long serialVersionUID = -3526903430795707644L;
    private String resourceContent;
    private Set<Attribute> attributes = new LazySet<Attribute>();

    public String getResourceContent() {
        return this.resourceContent;
    }

    public void setResourceContent(String content) {
        this.resourceContent = Strings.safeTrimOrNullString(content);
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Resource{ ");
        stringBuilder.append("content: ").append(this.resourceContent).append(", ");
        stringBuilder.append("attributes:[");
        Iterator<Attribute> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            stringBuilder.append(attribute);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + (null == this.resourceContent ? 0 : this.resourceContent.hashCode());
        hash = 31 * hash + ((Object)this.attributes).hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Resource otherResource = (Resource)obj;
        return Strings.safeEquals(this.resourceContent, otherResource.getResourceContent()) && ((Object)this.attributes).equals(otherResource.getAttributes());
    }
}

