/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4.client;

import org.dcache.chimera.nfs.v4.xdr.deviceid4;
import org.dcache.chimera.nfs.v4.xdr.nfs_fh4;

public class Stripe {
    private final long _offset;
    private final long _len;
    private final deviceid4 _deviceId;
    private final nfs_fh4 _fh;
    private final long _pattern_offset;
    private final int _unit;
    private final int _first_stripe_index;

    public Stripe(deviceid4 deviceId, nfs_fh4 fh, long len, long offset, long pattern_offset, int unit, int first_stripe_index) throws IllegalArgumentException {
        if (deviceId == null) {
            throw new IllegalArgumentException("device id is null");
        }
        this._deviceId = deviceId;
        if (fh == null) {
            throw new IllegalArgumentException("NFS file hadle is null");
        }
        this._fh = fh;
        this._len = len == -1L ? Long.MAX_VALUE : len;
        this._offset = offset;
        this._pattern_offset = pattern_offset;
        this._unit = unit;
        this._first_stripe_index = first_stripe_index;
    }

    public int getFirstStripeIndex() {
        return this._first_stripe_index;
    }

    public long getPatternOffset() {
        return this._pattern_offset;
    }

    public int getUnit() {
        return this._unit;
    }

    public long getOffset() {
        return this._offset;
    }

    public long getLen() {
        return this._len;
    }

    public deviceid4 getDeviceId() {
        return this._deviceId;
    }

    public nfs_fh4 getFh() {
        return this._fh;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._deviceId == null ? 0 : this._deviceId.hashCode());
        result = 31 * result + (this._fh == null ? 0 : this._fh.hashCode());
        result = 31 * result + (int)(this._len ^ this._len >>> 32);
        result = 31 * result + (int)(this._offset ^ this._offset >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Stripe)) {
            return false;
        }
        Stripe other = (Stripe)obj;
        if (!this._deviceId.equals(other._deviceId)) {
            return false;
        }
        if (this._len != other._len) {
            return false;
        }
        return this._offset == other._offset;
    }
}

