/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.io.IOException;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.SECINFO4res;
import org.dcache.chimera.nfs.v4.xdr.SECINFO4resok;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.rpcsec_gss_info;
import org.dcache.chimera.nfs.v4.xdr.secinfo4;
import org.dcache.chimera.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSECINFO
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationSECINFO.class);

    OperationSECINFO(nfs_argop4 args) {
        super(args, 33);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        SECINFO4res res = result.opsecinfo;
        Stat stat = context.getFs().getattr(context.currentInode());
        if (stat.type() != Stat.Type.DIRECTORY) {
            throw new ChimeraNFSException(20, "not a directory");
        }
        res.resok4 = new SECINFO4resok();
        res.resok4.value = new secinfo4[1];
        res.resok4.value[0] = new secinfo4();
        res.resok4.value[0].flavor = 1;
        res.resok4.value[0].flavor_info = new rpcsec_gss_info();
        context.clearCurrentInode();
        res.status = 0;
    }
}

