/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.io.IOException;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NameFilter;
import org.dcache.chimera.nfs.v4.xdr.LINK4resok;
import org.dcache.chimera.nfs.v4.xdr.change_info4;
import org.dcache.chimera.nfs.v4.xdr.changeid4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLINK
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLINK.class);

    OperationLINK(nfs_argop4 args) {
        super(args, 11);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        String newName = NameFilter.convert(this._args.oplink.newname.value.value.value);
        context.getFs().link(context.currentInode(), context.savedInode(), newName, context.getUser().getUID(), context.getUser().getGID());
        result.oplink.resok4 = new LINK4resok();
        result.oplink.resok4.cinfo = new change_info4();
        result.oplink.resok4.cinfo.atomic = true;
        result.oplink.resok4.cinfo.before = new changeid4(new uint64_t(context.getFs().getattr(context.currentInode()).getMTime()));
        result.oplink.resok4.cinfo.after = new changeid4(new uint64_t(System.currentTimeMillis()));
        result.oplink.status = 0;
    }
}

