/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.ClientCB;
import org.dcache.chimera.nfs.v4.NFS4State;
import org.dcache.chimera.nfs.v4.NFSv41Session;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.dcache.chimera.nfs.v4.xdr.verifier4;
import org.dcache.utils.Opaque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFS4Client {
    private static final Logger _log = LoggerFactory.getLogger(NFS4Client.class);
    private static final long BOOTID = System.currentTimeMillis() / 1000L;
    private static final AtomicInteger CLIENTID = new AtomicInteger(0);
    private final Opaque _ownerId;
    private final verifier4 _verifier;
    private final Principal _principal;
    private final long _clientId;
    private boolean _isConfirmed = false;
    private int _openStateId = 1;
    private int _sessionSequence = 1;
    private final Map<stateid4, NFS4State> _clientStates = new ConcurrentHashMap<stateid4, NFS4State>();
    private final int MAX_OPEN_STATES = 16384;
    private final Map<Integer, NFSv41Session> _sessions = new HashMap<Integer, NFSv41Session>();
    private long _cl_time = System.currentTimeMillis();
    private final InetSocketAddress _clientAddress;
    private final InetSocketAddress _localAddress;
    private ClientCB _cl_cb = null;
    private final long _leaseTime;

    public NFS4Client(InetSocketAddress clientAddress, InetSocketAddress localAddress, byte[] ownerID, verifier4 verifier, Principal principal, long leaseTime) {
        this._ownerId = new Opaque(ownerID);
        this._verifier = verifier;
        this._principal = principal;
        this._clientId = BOOTID << 32 | (long)CLIENTID.incrementAndGet();
        this._clientAddress = clientAddress;
        this._localAddress = localAddress;
        this._leaseTime = leaseTime;
        _log.debug("New client id: {}", (Object)Long.toHexString(this._clientId));
    }

    public void setCB(ClientCB cb) {
        this._cl_cb = cb;
    }

    public ClientCB getCB() {
        return this._cl_cb;
    }

    public Opaque getOwner() {
        return this._ownerId;
    }

    public verifier4 verifier() {
        return this._verifier;
    }

    public long getId() {
        return this._clientId;
    }

    public boolean verifierEquals(verifier4 verifier) {
        return this._verifier.equals(verifier);
    }

    public boolean isConfirmed() {
        return this._isConfirmed;
    }

    public void setConfirmed() {
        this._isConfirmed = true;
    }

    public boolean isLeaseValid() {
        return System.currentTimeMillis() - this._cl_time > this._leaseTime;
    }

    public void updateLeaseTime() throws ChimeraNFSException {
        long curentTime = System.currentTimeMillis();
        if (curentTime - this._cl_time > this._leaseTime) {
            this._clientStates.clear();
            throw new ChimeraNFSException(10011, "lease time expired");
        }
        this._cl_time = curentTime;
    }

    public void refreshLeaseTime() {
        this._cl_time = System.currentTimeMillis();
    }

    public InetSocketAddress getRemoteAddress() {
        return this._clientAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this._localAddress;
    }

    public int currentSeqID() {
        return this._sessionSequence;
    }

    public NFS4State createState() throws ChimeraNFSException {
        if (this._clientStates.size() >= 16384) {
            throw new ChimeraNFSException(10018, "Too many states.");
        }
        NFS4State state = new NFS4State(this._clientId, this._openStateId);
        ++this._openStateId;
        this._clientStates.put(state.stateid(), state);
        return state;
    }

    public NFS4State releaseState(stateid4 stateid) throws ChimeraNFSException {
        NFS4State state = this._clientStates.remove(stateid);
        if (state == null) {
            throw new ChimeraNFSException(10025, "State not known to the client.");
        }
        return state;
    }

    public NFS4State state(stateid4 stateid) throws ChimeraNFSException {
        NFS4State state = this._clientStates.get(stateid);
        if (state == null) {
            throw new ChimeraNFSException(10025, "State not known to the client.");
        }
        return state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._clientAddress).append(":").append(this._ownerId).append("@").append(this._clientId);
        return sb.toString();
    }

    public Collection<NFSv41Session> sessions() {
        return this._sessions.values();
    }

    public NFSv41Session createSession(int sequence, int cacheSize) throws ChimeraNFSException {
        _log.debug("session for sequience: {}", (Object)sequence);
        if (sequence > this._sessionSequence && this._isConfirmed) {
            throw new ChimeraNFSException(10063, "bad sequence id: " + this._sessionSequence + " / " + sequence);
        }
        if (sequence == this._sessionSequence - 1 && !this._isConfirmed) {
            throw new ChimeraNFSException(10063, "bad sequence id: " + this._sessionSequence + " / " + sequence);
        }
        if (sequence == this._sessionSequence - 1) {
            _log.debug("Retransmit on create session detected");
            return this._sessions.get(sequence);
        }
        if (sequence != this._sessionSequence) {
            throw new ChimeraNFSException(10063, "bad sequence id: " + this._sessionSequence + " / " + sequence);
        }
        NFSv41Session session = new NFSv41Session(this, this._sessionSequence, cacheSize);
        this._sessions.put(this._sessionSequence, session);
        ++this._sessionSequence;
        if (!this._isConfirmed) {
            this._isConfirmed = true;
            _log.debug("set client confirmed");
        }
        return session;
    }

    public void removeSession(NFSv41Session session) {
        this._sessions.remove(session.getSequence());
    }

    public boolean sessionsEmpty(NFSv41Session session) {
        return this._sessions.isEmpty();
    }

    public Principal principal() {
        return this._principal;
    }

    public boolean hasState() {
        return !this._clientStates.isEmpty();
    }
}

