/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs;

import com.google.common.base.CharMatcher;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.dcache.chimera.nfs.FsExport;
import org.dcache.chimera.nfs.HostEntryComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportFile {
    private static final Logger _log = LoggerFactory.getLogger(ExportFile.class);
    private volatile List<FsExport> _exports;
    private final URL _exportFile;

    public ExportFile(File file) throws IOException {
        this(file.toURI().toURL());
    }

    public ExportFile(URL url) throws IOException {
        this._exportFile = url;
        this._exports = ExportFile.parse(this._exportFile);
    }

    public List<FsExport> getExports() {
        return Lists.newArrayList(this._exports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FsExport> parse(URL exportFile) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(exportFile.openStream()));
        ArrayList<FsExport> exports2 = new ArrayList<FsExport>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                int pathEnd = line.indexOf(32);
                if (pathEnd < 0) {
                    FsExport export = new FsExport.FsExportBuilder().build(line);
                    exports2.add(export);
                    continue;
                }
                String path = line.substring(0, pathEnd);
                Splitter splitter = Splitter.on((char)' ').omitEmptyStrings().trimResults();
                for (String hostAndOptions : splitter.split((CharSequence)line.substring(pathEnd + 1))) {
                    try {
                        FsExport.FsExportBuilder exportBuilder = new FsExport.FsExportBuilder();
                        Iterator s = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"(,)")).omitEmptyStrings().trimResults().split((CharSequence)hostAndOptions).iterator();
                        String host = (String)s.next();
                        if (!ExportFile.isValidHostSpecifier(host)) {
                            _log.error("Invalid host specifier: " + host);
                            continue;
                        }
                        exportBuilder.forClient(host);
                        while (s.hasNext()) {
                            String option = (String)s.next();
                            if (option.equals("rw")) {
                                exportBuilder.rw();
                                continue;
                            }
                            if (option.equals("ro")) {
                                exportBuilder.ro();
                                continue;
                            }
                            if (option.equals("root_squash")) {
                                exportBuilder.notTrusted();
                                continue;
                            }
                            if (option.equals("no_root_squash")) {
                                exportBuilder.trusted();
                                continue;
                            }
                            if (option.equals("acl")) {
                                exportBuilder.withAcl();
                                continue;
                            }
                            if (option.equals("noacl")) {
                                exportBuilder.withoutAcl();
                                continue;
                            }
                            if (option.startsWith("sec=")) {
                                String secFlavor = option.substring(4);
                                exportBuilder.withSec(FsExport.Sec.valueOf(secFlavor.toUpperCase()));
                                continue;
                            }
                            throw new IllegalArgumentException("Unsupported option: " + option);
                        }
                        FsExport export = exportBuilder.build(path);
                        exports2.add(export);
                    }
                    catch (IllegalArgumentException e) {
                        _log.error("Invalid export entry [" + hostAndOptions + "] : " + e.getMessage());
                    }
                }
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException dummy) {}
        }
        Collections.sort(exports2, new Comparator<FsExport>(){

            @Override
            public int compare(FsExport e1, FsExport e2) {
                return HostEntryComparator.compare(e1.client(), e2.client());
            }
        });
        return exports2;
    }

    private static boolean isValidHostSpecifier(String s) {
        String mask;
        String host;
        int maskIdx = s.indexOf(47);
        if (maskIdx < 0) {
            host = s;
            mask = "128";
        } else {
            host = s.substring(0, maskIdx);
            mask = s.substring(maskIdx + 1);
        }
        return ExportFile.isValidIpAddress(host) && ExportFile.isValidNetmask(mask) || ExportFile.isValidHostName(host) || ExportFile.isValidWildcard(host);
    }

    private static boolean isValidIpAddress(String s) {
        try {
            InetAddresses.forString((String)s);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private static boolean isValidHostName(String s) {
        return InternetDomainName.isValid((String)s);
    }

    private static boolean isValidWildcard(String s) {
        return ExportFile.isValidHostName(s.replace('?', 'a').replace('*', 'a'));
    }

    private static boolean isValidNetmask(String s) {
        try {
            int mask = Integer.parseInt(s);
            return mask >= 0 && mask <= 128;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public FsExport getExport(String path, InetAddress client) {
        for (FsExport export : this._exports) {
            if (!export.getPath().equals(path) || !export.isAllowed(client)) continue;
            return export;
        }
        return null;
    }

    public FsExport getExport(int index, InetAddress client) {
        for (FsExport export : this._exports) {
            if (export.getIndex() != index || !export.isAllowed(client)) continue;
            return export;
        }
        return null;
    }

    public boolean isTrusted(InetAddress client) {
        List<FsExport> exports2 = this.getExports();
        for (FsExport export : exports2) {
            if (!export.isTrusted(client)) continue;
            return true;
        }
        return false;
    }

    public Collection<FsExport> exportsFor(InetAddress client) {
        return Collections2.filter(this._exports, (Predicate)new AllowedExports(client));
    }

    public void rescan() throws IOException {
        this._exports = ExportFile.parse(this._exportFile);
    }

    private static class AllowedExports
    implements Predicate<FsExport> {
        private final InetAddress _client;

        public AllowedExports(InetAddress client) {
            this._client = client;
        }

        public boolean apply(FsExport export) {
            return export.isAllowed(this._client);
        }
    }
}

