/*
 * Decompiled with CFR 0.152.
 */
package statemap;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Stack;
import statemap.State;

public abstract class FSMContext
implements Serializable {
    protected transient String _name = "FSMContext";
    protected transient State _state;
    protected transient String _transition;
    protected transient State _previousState;
    protected transient Stack<State> _stateStack;
    protected transient boolean _debugFlag;
    protected transient PrintStream _debugStream;
    private transient PropertyChangeSupport _listeners;
    private static final long serialVersionUID = 393216L;
    private static final String STATE_PROPERTY = "State";

    protected FSMContext(State initState) {
        this._state = initState;
        this._transition = "";
        this._previousState = null;
        this._stateStack = null;
        this._debugFlag = false;
        this._debugStream = System.err;
        this._listeners = new PropertyChangeSupport(this);
    }

    public abstract void enterStartState();

    private void readObject(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        istream.defaultReadObject();
        this._listeners = new PropertyChangeSupport(this);
    }

    public String getName() {
        return this._name;
    }

    public boolean getDebugFlag() {
        return this._debugFlag && this._debugStream != null;
    }

    public PrintStream getDebugStream() {
        return this._debugStream == null ? System.err : this._debugStream;
    }

    public boolean isInTransition() {
        return this._state == null;
    }

    public State getPreviousState() throws NullPointerException {
        return this._previousState;
    }

    public String getTransition() {
        return this._transition;
    }

    public void setName(String name) {
        if (name != null && name.length() > 0 && !name.equals(this._name)) {
            this._name = name;
        }
    }

    public void setDebugFlag(boolean flag) {
        this._debugFlag = flag;
    }

    public void setDebugStream(PrintStream stream) {
        this._debugStream = stream;
    }

    public void setState(State state) {
        if (this.getDebugFlag()) {
            this.getDebugStream().println("ENTER STATE     : " + state.getName());
        }
        if (this._state != null) {
            this._previousState = this._state;
        }
        this._state = state;
        this._listeners.firePropertyChange(STATE_PROPERTY, this._previousState, this._state);
    }

    public void clearState() {
        this._previousState = this._state;
        this._state = null;
    }

    public void pushState(State state) {
        if (this._state == null) {
            throw new NullPointerException();
        }
        if (this.getDebugFlag()) {
            this.getDebugStream().println("PUSH TO STATE   : " + state.getName());
        }
        if (this._stateStack == null) {
            this._stateStack = new Stack();
        }
        this._previousState = this._state;
        this._stateStack.push(this._state);
        this._state = state;
        this._listeners.firePropertyChange(STATE_PROPERTY, this._previousState, this._state);
    }

    public void popState() throws EmptyStackException {
        if (this._stateStack == null || this._stateStack.isEmpty()) {
            if (this.getDebugFlag()) {
                this.getDebugStream().println("POPPING ON EMPTY STATE STACK.");
            }
            throw new EmptyStackException();
        }
        this._previousState = this._state;
        this._state = this._stateStack.pop();
        if (this._stateStack.isEmpty()) {
            this._stateStack = null;
        }
        if (this.getDebugFlag()) {
            this.getDebugStream().println("POP TO STATE    : " + this._state.getName());
        }
        this._listeners.firePropertyChange(STATE_PROPERTY, this._previousState, this._state);
    }

    public void emptyStateStack() {
        if (this._stateStack != null) {
            this._stateStack.clear();
            this._stateStack = null;
        }
    }

    public void addStateChangeListener(PropertyChangeListener listener) {
        this._listeners.addPropertyChangeListener(STATE_PROPERTY, listener);
    }

    public void removeStateChangeListener(PropertyChangeListener listener) {
        this._listeners.removePropertyChangeListener(STATE_PROPERTY, listener);
    }
}

