/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PermissionDeniedCacheException;
import io.milton.http.Auth;
import io.milton.http.Filter;
import io.milton.http.FilterChain;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.resource.Resource;
import io.milton.servlet.ServletRequest;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.Origin;
import org.dcache.auth.PasswordCredential;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.webdav.EmptyResource;
import org.dcache.webdav.RedirectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityFilter
implements Filter {
    private final Logger _log = LoggerFactory.getLogger(SecurityFilter.class);
    private static final String X509_CERTIFICATE_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private String _realm;
    private boolean _isReadOnly;
    private boolean _isBasicAuthenticationEnabled;
    private LoginStrategy _loginStrategy;
    private FsPath _rootPath = new FsPath();

    public void process(final FilterChain filterChain, final Request request, final Response response) {
        HttpManager manager = filterChain.getHttpManager();
        Subject subject = new Subject();
        if (!this.isAllowedMethod(request.getMethod())) {
            manager.getResponseHandler().respondMethodNotAllowed((Resource)new EmptyResource(request), response, request);
            return;
        }
        try {
            HttpServletRequest servletRequest = ServletRequest.getRequest();
            this.addX509ChainToSubject(servletRequest, subject);
            this.addOriginToSubject(servletRequest, subject);
            this.addPasswordCredentialToSubject(request, subject);
            LoginReply login = this._loginStrategy.login(subject);
            subject = login.getSubject();
            if (!this.isAuthorizedMethod(request.getMethod(), login)) {
                throw new PermissionDeniedCacheException("Permission denied");
            }
            this.checkRootPath(request, login);
            this.addOriginToSubject(servletRequest, subject);
            Auth auth = request.getAuthorization();
            if (auth != null) {
                auth.setTag((Object)subject);
            }
            Subject.doAs(subject, new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    filterChain.process(request, response);
                    return null;
                }
            });
        }
        catch (RedirectException e) {
            manager.getResponseHandler().respondRedirect(response, request, e.getUrl());
        }
        catch (PermissionDeniedCacheException e) {
            this._log.warn("{} for path {} and {}", new Object[]{e.getMessage(), request.getAbsolutePath(), subject});
            manager.getResponseHandler().respondUnauthorised((Resource)new EmptyResource(request), response, request);
        }
        catch (CacheException e) {
            this._log.error("Internal server error: " + (Object)((Object)e));
            manager.getResponseHandler().respondServerError(request, response, e.getMessage());
        }
    }

    private void checkRootPath(Request request, LoginReply login) throws CacheException {
        FsPath userRoot = new FsPath();
        FsPath userHome = new FsPath();
        for (LoginAttribute attribute : login.getLoginAttributes()) {
            if (attribute instanceof RootDirectory) {
                userRoot = new FsPath(((RootDirectory)attribute).getRoot());
                continue;
            }
            if (!(attribute instanceof HomeDirectory)) continue;
            userHome = new FsPath(((HomeDirectory)attribute).getHome());
        }
        String path = request.getAbsolutePath();
        FsPath fullPath = new FsPath(new FsPath[]{this._rootPath, new FsPath(path)});
        if (!fullPath.startsWith(userRoot)) {
            if (!path.equals("/")) {
                throw new PermissionDeniedCacheException("Permission denied");
            }
            try {
                FsPath redirectFullPath = new FsPath(new FsPath[]{userRoot, userHome});
                String redirectPath = this._rootPath.relativize(redirectFullPath).toString();
                URI uri = new URI(request.getAbsoluteUrl());
                URI redirect = new URI(uri.getScheme(), uri.getAuthority(), redirectPath, null, null);
                throw new RedirectException(null, redirect.toString());
            }
            catch (URISyntaxException e) {
                throw new CacheException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addX509ChainToSubject(HttpServletRequest request, Subject subject) {
        Object object = request.getAttribute(X509_CERTIFICATE_ATTRIBUTE);
        if (object instanceof X509Certificate[]) {
            X509Certificate[] chain = (X509Certificate[])object;
            subject.getPublicCredentials().add(chain);
        }
    }

    private void addOriginToSubject(HttpServletRequest request, Subject subject) {
        String address = request.getRemoteAddr();
        try {
            Origin origin = new Origin(Origin.AuthType.ORIGIN_AUTHTYPE_STRONG, InetAddress.getByName(address));
            subject.getPrincipals().add((Principal)origin);
        }
        catch (UnknownHostException e) {
            this._log.warn("Failed to resolve " + address + ": " + e.getMessage());
        }
    }

    private void addPasswordCredentialToSubject(Request request, Subject subject) {
        Auth auth = request.getAuthorization();
        if (auth != null && auth.getScheme().equals((Object)Auth.Scheme.BASIC) && this._isBasicAuthenticationEnabled) {
            PasswordCredential credential = new PasswordCredential(auth.getUser(), auth.getPassword());
            subject.getPrivateCredentials().add(credential);
        }
    }

    private boolean isAllowedMethod(Request.Method method) {
        return !this._isReadOnly || this.isReadMethod(method);
    }

    private boolean isAuthorizedMethod(Request.Method method, LoginReply login) {
        return !this.isUserReadOnly(login) || this.isReadMethod(method);
    }

    private boolean isUserReadOnly(LoginReply login) {
        for (LoginAttribute attribute : login.getLoginAttributes()) {
            if (!(attribute instanceof ReadOnly)) continue;
            return ((ReadOnly)attribute).isReadOnly();
        }
        return false;
    }

    private boolean isReadMethod(Request.Method method) {
        switch (method) {
            case GET: 
            case HEAD: 
            case OPTIONS: 
            case PROPFIND: {
                return true;
            }
        }
        return false;
    }

    public String getRealm() {
        return this._realm;
    }

    public void setRealm(String realm) {
        this._realm = realm;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    public void setEnableBasicAuthentication(boolean isEnabled) {
        this._isBasicAuthenticationEnabled = isEnabled;
    }

    public void setLoginStrategy(LoginStrategy loginStrategy) {
        this._loginStrategy = loginStrategy;
    }

    public String getRootPath() {
        return this._rootPath.toString();
    }

    public void setRootPath(String path) {
        this._rootPath = new FsPath(path);
    }
}

