/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellInfo;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.servlet.ServletRequest;
import io.milton.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dcache.cells.CellMessageSender;
import org.dcache.util.Transfer;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;

public class MiltonHandler
extends AbstractHandler
implements CellMessageSender {
    private HttpManager _httpManager;
    private String _cellName;
    private String _domainName;

    public void setHttpManager(HttpManager httpManager) {
        this._httpManager = httpManager;
    }

    public void setCellEndpoint(CellEndpoint endpoint) {
        CellInfo info = endpoint.getCellInfo();
        this._cellName = info.getCellName();
        this._domainName = info.getDomainName();
    }

    public void handle(String target, org.eclipse.jetty.server.Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try (CDC ignored = CDC.reset((String)this._cellName, (String)this._domainName);){
            Transfer.initSession();
            ContextHandler.Context context = ContextHandler.getCurrentContext();
            DcacheServletRequest req = new DcacheServletRequest(request, (ServletContext)context);
            DcacheServletResponse resp = new DcacheServletResponse(response);
            baseRequest.setHandled(true);
            this._httpManager.process((Request)req, (Response)resp);
            response.getOutputStream().flush();
            response.flushBuffer();
        }
    }

    private class DcacheServletResponse
    extends ServletResponse {
        public DcacheServletResponse(HttpServletResponse r) {
            super(r);
        }

        public void setContentLengthHeader(Long length) {
            if (length != null) {
                super.setContentLengthHeader(length);
            }
        }
    }

    private class DcacheServletRequest
    extends ServletRequest {
        public DcacheServletRequest(HttpServletRequest request, ServletContext context) {
            super(request, context);
        }

        public InputStream getInputStream() {
            return new InputStream(){
                private InputStream inner;

                private InputStream getRealInputStream() throws IOException {
                    if (this.inner == null) {
                        this.inner = DcacheServletRequest.super.getInputStream();
                    }
                    return this.inner;
                }

                @Override
                public int read() throws IOException {
                    return this.getRealInputStream().read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return this.getRealInputStream().read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return this.getRealInputStream().read(b, off, len);
                }

                @Override
                public long skip(long n) throws IOException {
                    return this.getRealInputStream().skip(n);
                }

                @Override
                public int available() throws IOException {
                    return this.getRealInputStream().available();
                }

                @Override
                public void close() throws IOException {
                    this.getRealInputStream().close();
                }

                @Override
                public synchronized void mark(int readlimit) {
                    throw new UnsupportedOperationException("Mark is unsupported");
                }

                @Override
                public synchronized void reset() throws IOException {
                    this.getRealInputStream().reset();
                }

                @Override
                public boolean markSupported() {
                    return false;
                }
            };
        }
    }
}

