/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import com.google.common.base.Joiner;
import com.google.common.primitives.Longs;
import io.milton.http.Auth;
import io.milton.http.Filter;
import io.milton.http.FilterChain;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.servlet.ServletRequest;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.NoSuchElementException;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.dcache.auth.Subjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFilter
implements Filter {
    private final Logger _log = LoggerFactory.getLogger(LoggingFilter.class);
    private static final String X509_CERTIFICATE_ATTRIBUTE = "javax.servlet.request.X509Certificate";

    public void process(FilterChain filterChain, Request request, Response response) {
        try {
            filterChain.process(request, response);
            Response.Status status = response.getStatus();
            if (status != null) {
                this._log.info("{} {} {} {} {}", new Object[]{request.getFromAddress(), request.getMethod(), request.getAbsolutePath(), this.getUser(request), status.code});
            } else {
                this._log.info("{} {} {} {}", new Object[]{request.getFromAddress(), request.getMethod(), request.getAbsolutePath(), this.getUser(request)});
            }
        }
        catch (RuntimeException e) {
            this._log.warn(String.format("%s %s %s %s", request.getFromAddress(), request.getMethod(), request.getAbsolutePath(), this.getUser(request)), (Throwable)e);
            throw e;
        }
    }

    private String getUser(Request request) {
        StringBuilder sb = new StringBuilder();
        String certificateName = this.getCertificateName();
        String subjectName = this.getSubjectName(request);
        sb.append("[");
        if (certificateName.isEmpty() && subjectName.isEmpty()) {
            sb.append("ANONYMOUS");
        } else {
            sb.append(certificateName);
            if (!certificateName.isEmpty() && !subjectName.isEmpty()) {
                sb.append("; ");
            }
            sb.append(subjectName);
        }
        sb.append("]");
        return sb.toString();
    }

    private String getCertificateName() {
        X509Certificate[] chain;
        HttpServletRequest servletRequest = ServletRequest.getRequest();
        Object object = servletRequest.getAttribute(X509_CERTIFICATE_ATTRIBUTE);
        if (object instanceof X509Certificate[] && (chain = (X509Certificate[])object).length >= 1) {
            return chain[0].getSubjectX500Principal().getName();
        }
        return "";
    }

    private String getSubjectName(Request request) {
        String uid;
        Auth auth = request.getAuthorization();
        if (auth == null) {
            return "";
        }
        Subject subject = (Subject)auth.getTag();
        if (subject == null) {
            return "";
        }
        if (subject.equals(Subjects.NOBODY)) {
            return "NOBODY";
        }
        if (subject.equals(Subjects.ROOT)) {
            return "ROOT";
        }
        try {
            uid = Long.toString(Subjects.getUid((Subject)subject));
        }
        catch (NoSuchElementException e) {
            uid = "unknown";
        }
        List gids = Longs.asList((long[])Subjects.getGids((Subject)subject));
        return "uid=" + uid + ", gid={" + Joiner.on((String)",").join((Iterable)gids) + "}";
    }
}

