/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import io.milton.http.Filter;
import io.milton.http.FilterChain;
import io.milton.http.Handler;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.resource.Resource;
import org.dcache.webdav.EmptyResource;
import org.dcache.webdav.ForbiddenException;
import org.dcache.webdav.RedirectException;
import org.dcache.webdav.UnauthorizedException;
import org.dcache.webdav.WebDavException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcacheStandardFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DcacheStandardFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(FilterChain chain, Request request, Response response) {
        HttpManager manager = chain.getHttpManager();
        Http11ResponseHandler responseHandler = manager.getResponseHandler();
        try {
            Request.Method method = request.getMethod();
            Handler handler = manager.getMethodHandler(method);
            if (handler == null) {
                responseHandler.respondMethodNotImplemented((Resource)new EmptyResource(request), response, request);
                return;
            }
            try {
                handler.process(manager, request, response);
                if (response.getEntity() != null) {
                    manager.sendResponseEntity(response);
                }
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof WebDavException) {
                    throw (WebDavException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw e;
            }
        }
        catch (BadRequestException e) {
            responseHandler.respondBadRequest(e.getResource(), response, request);
        }
        catch (ConflictException e) {
            responseHandler.respondConflict(e.getResource(), response, request, e.getMessage());
        }
        catch (NotAuthorizedException e) {
            responseHandler.respondUnauthorised(e.getResource(), response, request);
        }
        catch (UnauthorizedException e) {
            responseHandler.respondUnauthorised(e.getResource(), response, request);
        }
        catch (ForbiddenException e) {
            responseHandler.respondForbidden(e.getResource(), response, request);
        }
        catch (NotFoundException e) {
            responseHandler.respondNotFound(response, request);
        }
        catch (RedirectException e) {
            response.setStatus(Response.Status.SC_TEMPORARY_REDIRECT);
            response.setLocationHeader(e.getUrl());
        }
        catch (WebDavException e) {
            log.warn("Internal server error: {}", (Object)e.toString());
            responseHandler.respondServerError(request, response, e.getMessage());
        }
        catch (RuntimeException e) {
            log.error("Internal server error", (Throwable)e);
            responseHandler.respondServerError(request, response, e.getMessage());
        }
        catch (Exception e) {
            log.error("Internal server error: {}", (Object)e.toString());
            responseHandler.respondServerError(request, response, e.getMessage());
        }
        finally {
            manager.closeResponse(response);
        }
    }
}

