/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.milton.http.AbstractWrappingResponseHandler;
import io.milton.http.AuthenticationService;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.values.ValueAndType;
import io.milton.http.webdav.PropFindResponse;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.AccessController;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.dcache.webdav.DcacheFileResource;
import org.dcache.webdav.UrlPathWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class DcacheResponseHandler
extends AbstractWrappingResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(DcacheResponseHandler.class);
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private final ImmutableMap<Response.Status, String> ERRORS = ImmutableMap.builder().put((Object)Response.Status.SC_INTERNAL_SERVER_ERROR, (Object)"INTERNAL SERVER ERROR").put((Object)Response.Status.SC_FORBIDDEN, (Object)"PERMISSION DENIED").put((Object)Response.Status.SC_BAD_REQUEST, (Object)"BAD REQUEST").put((Object)Response.Status.SC_NOT_IMPLEMENTED, (Object)"NOT IMPLEMENTED").put((Object)Response.Status.SC_CONFLICT, (Object)"CONFLICT").put((Object)Response.Status.SC_UNAUTHORIZED, (Object)"UNAUTHORIZED").put((Object)Response.Status.SC_METHOD_NOT_ALLOWED, (Object)"METHOD NOT ALLOWED").put((Object)Response.Status.SC_NOT_FOUND, (Object)"FILE NOT FOUND").build();
    private AuthenticationService _authenticationService;
    private String _staticContentPath;
    private STGroup _templateGroup;

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this._authenticationService = authenticationService;
    }

    public void setTemplateResource(org.springframework.core.io.Resource resource) throws IOException {
        this._templateGroup = new STGroupFile(resource.getURL(), "UTF-8", '$', '$');
    }

    public String getStaticContentPath() {
        return this._staticContentPath;
    }

    public void setStaticContentPath(String path) {
        this._staticContentPath = path;
    }

    public void respondNotFound(Response response, Request request) {
        this.errorResponse(request, response, Response.Status.SC_NOT_FOUND);
    }

    public void respondUnauthorised(Resource resource, Response response, Request request) {
        List challenges = this._authenticationService.getChallenges(resource, request);
        response.setAuthenticateHeader(challenges);
        this.errorResponse(request, response, Response.Status.SC_UNAUTHORIZED);
    }

    public void respondMethodNotImplemented(Resource resource, Response response, Request request) {
        this.errorResponse(request, response, Response.Status.SC_NOT_IMPLEMENTED);
    }

    public void respondMethodNotAllowed(Resource resource, Response response, Request request) {
        this.errorResponse(request, response, Response.Status.SC_METHOD_NOT_ALLOWED);
    }

    public void respondServerError(Request request, Response response, String reason) {
        this.errorResponse(request, response, Response.Status.SC_INTERNAL_SERVER_ERROR);
    }

    public void respondConflict(Resource resource, Response response, Request request, String reason) {
        this.errorResponse(request, response, Response.Status.SC_CONFLICT);
    }

    public void respondForbidden(Resource resource, Response response, Request request) {
        this.errorResponse(request, response, Response.Status.SC_FORBIDDEN);
    }

    private void errorResponse(Request request, Response response, Response.Status status) {
        try {
            String decodedPath = URI.create(request.getAbsoluteUrl()).getPath();
            String error = this.generateErrorPage(decodedPath, status);
            response.setStatus(status);
            response.setContentTypeHeader("text/html");
            OutputStream out = response.getOutputStream();
            out.write(error.getBytes());
        }
        catch (IOException ex) {
            log.warn("exception writing content");
        }
    }

    private String generateErrorPage(String path, Response.Status status) {
        String[] base = (String[])Iterables.toArray((Iterable)PATH_SPLITTER.split((CharSequence)path), String.class);
        ST template = this._templateGroup.getInstanceOf("errorpage");
        template.add("path", (Object)UrlPathWrapper.forPaths(base));
        template.add("base", (Object)UrlPathWrapper.forEmptyPath());
        template.add("static", (Object)this._staticContentPath);
        template.add("errorcode", (Object)status.toString());
        template.add("errormessage", this.ERRORS.get((Object)status));
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null) {
            template.add("subject", (Object)subject.getPrincipals().toString());
        }
        return template.render();
    }

    public void respondPropFind(List<PropFindResponse> propFindResponses, Response response, Request request, Resource r) {
        for (PropFindResponse propFindResponse : propFindResponses) {
            Map errors = propFindResponse.getErrorProperties();
            List unknownProperties = (List)errors.get(Response.Status.SC_NOT_FOUND);
            if (unknownProperties == null) {
                unknownProperties = Lists.newArrayList();
                errors.put(Response.Status.SC_NOT_FOUND, unknownProperties);
            }
            Iterator iterator = propFindResponse.getKnownProperties().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((ValueAndType)entry.getValue()).getValue() != null) continue;
                unknownProperties.add(new PropFindResponse.NameAndError((QName)entry.getKey(), null));
                iterator.remove();
            }
        }
        super.respondPropFind(propFindResponses, response, request, r);
    }

    public void respondHead(Resource resource, Response response, Request request) {
        super.respondHead(resource, response, request);
        this.rfc3230(resource, response);
    }

    public void respondPartialContent(GetableResource resource, Response response, Request request, Map<String, String> params, Range range) throws NotAuthorizedException, BadRequestException, NotFoundException {
        super.respondPartialContent(resource, response, request, params, range);
        this.rfc3230((Resource)resource, response);
    }

    public void respondContent(Resource resource, Response response, Request request, Map<String, String> params) throws NotAuthorizedException, BadRequestException, NotFoundException {
        super.respondContent(resource, response, request, params);
        this.rfc3230(resource, response);
    }

    private void rfc3230(Resource resource, Response response) {
        DcacheFileResource file;
        String digest;
        if (resource instanceof DcacheFileResource && !(digest = (file = (DcacheFileResource)resource).getRfc3230Digest()).isEmpty()) {
            response.setNonStandardHeader("Digest", digest);
        }
    }
}

