/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ranges;
import com.google.common.io.ByteStreams;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.DoorRequestInfoMessage;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.GFtpProtocolInfo;
import diskCacheV111.vehicles.HttpDoorUrlInfoMessage;
import diskCacheV111.vehicles.HttpProtocolInfo;
import diskCacheV111.vehicles.IoDoorEntry;
import diskCacheV111.vehicles.IoDoorInfo;
import diskCacheV111.vehicles.PnfsCreateEntryMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.LoginManagerChildrenInfo;
import dmg.util.Args;
import io.milton.http.HttpManager;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.dcache.auth.SubjectWrapper;
import org.dcache.auth.Subjects;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.missingfiles.AlwaysFailMissingFileStrategy;
import org.dcache.missingfiles.MissingFileStrategy;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.util.PingMoversTask;
import org.dcache.util.RedirectedTransfer;
import org.dcache.util.Transfer;
import org.dcache.util.TransferRetryPolicies;
import org.dcache.util.TransferRetryPolicy;
import org.dcache.util.list.DirectoryEntry;
import org.dcache.util.list.DirectoryListPrinter;
import org.dcache.util.list.ListDirectoryHandler;
import org.dcache.vehicles.FileAttributes;
import org.dcache.webdav.DcacheDirectoryResource;
import org.dcache.webdav.DcacheFileResource;
import org.dcache.webdav.DcacheResource;
import org.dcache.webdav.UnauthorizedException;
import org.dcache.webdav.UrlPathWrapper;
import org.dcache.webdav.WebDavException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;

public class DcacheResourceFactory
extends AbstractCellComponent
implements ResourceFactory,
CellMessageReceiver,
CellCommandListener {
    private static final Logger _log = LoggerFactory.getLogger(DcacheResourceFactory.class);
    private static final Set<FileAttribute> REQUIRED_ATTRIBUTES = EnumSet.of(FileAttribute.TYPE, new FileAttribute[]{FileAttribute.PNFSID, FileAttribute.CREATION_TIME, FileAttribute.MODIFICATION_TIME, FileAttribute.SIZE, FileAttribute.MODE, FileAttribute.OWNER, FileAttribute.OWNER_GROUP});
    private static final String PROTOCOL_INFO_NAME = "Http";
    private static final int PROTOCOL_INFO_MAJOR_VERSION = 1;
    private static final int PROTOCOL_INFO_MINOR_VERSION = 1;
    private static final int PROTOCOL_INFO_UNKNOWN_PORT = 0;
    private static final String RELAY_PROTOCOL_INFO_NAME = "GFtp";
    private static final int RELAY_PROTOCOL_INFO_MAJOR_VERSION = 1;
    private static final int RELAY_PROTOCOL_INFO_MINOR_VERSION = 0;
    private static final int RELAY_PROTOCOL_INFO_STREAMS = 1;
    private static final int RELAY_PROTOCOL_INFO_BUFFERSIZE = 0;
    private static final int RELAY_PROTOCOL_INFO_OFFSET = 0;
    private static final int RELAY_PROTOCOL_INFO_SIZE = 0;
    private static final long PING_DELAY = 300000L;
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private final Map<Integer, HttpTransfer> _transfers = Maps.newConcurrentMap();
    private ListDirectoryHandler _list;
    private ScheduledExecutorService _executor;
    private int _moverTimeout = 180000;
    private long _killTimeout = 1500L;
    private long _transferConfirmationTimeout = 60000L;
    private int _bufferSize = 65536;
    private CellStub _poolStub;
    private CellStub _poolManagerStub;
    private CellStub _billingStub;
    private PnfsHandler _pnfs;
    private String _ioQueue;
    private FsPath _rootPath = new FsPath();
    private List<FsPath> _allowedPaths = Collections.singletonList(new FsPath());
    private InetAddress _internalAddress;
    private String _path;
    private boolean _doRedirectOnRead = true;
    private boolean _doRedirectOnWrite = true;
    private boolean _isOverwriteAllowed;
    private boolean _isAnonymousListingAllowed;
    private String _staticContentPath;
    private STGroup _listingGroup;
    private TransferRetryPolicy _retryPolicy = TransferRetryPolicies.tryOncePolicy((long)this._moverTimeout);
    private MissingFileStrategy _missingFileStrategy = new AlwaysFailMissingFileStrategy();
    public static final String hh_get_children = "[-binary]";
    public static final String hh_get_door_info = "[-binary]";

    public DcacheResourceFactory() throws UnknownHostException {
        this._internalAddress = InetAddress.getLocalHost();
    }

    public long getKillTimeout() {
        return this._killTimeout;
    }

    public void setKillTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        this._killTimeout = timeout;
    }

    public int getMoverTimeout() {
        return this._moverTimeout;
    }

    public void setMoverTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        this._moverTimeout = timeout;
        this._retryPolicy = TransferRetryPolicies.tryOncePolicy((long)this._moverTimeout);
    }

    public long getTransferConfirmationTimeout() {
        return this._transferConfirmationTimeout;
    }

    public void setTransferConfirmationTimeout(long timeout) {
        this._transferConfirmationTimeout = timeout;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public String getRootPath() {
        return this._rootPath.toString();
    }

    public void setRootPath(String path) {
        this._rootPath = new FsPath(path);
    }

    public void setAllowedPaths(String s) {
        ArrayList<FsPath> list = new ArrayList<FsPath>();
        for (String path : s.split(":")) {
            list.add(new FsPath(path));
        }
        this._allowedPaths = list;
    }

    public String getAllowedPaths() {
        StringBuilder s = new StringBuilder();
        for (FsPath path : this._allowedPaths) {
            if (s.length() > 0) {
                s.append(':');
            }
            s.append(path);
        }
        return s.toString();
    }

    public String getIoQueue() {
        return this._ioQueue == null ? "" : this._ioQueue;
    }

    public void setIoQueue(String ioQueue) {
        this._ioQueue = ioQueue != null && !ioQueue.isEmpty() ? ioQueue : null;
    }

    public void setRedirectOnReadEnabled(boolean redirect) {
        this._doRedirectOnRead = redirect;
    }

    public boolean isRedirectOnReadEnabled() {
        return this._doRedirectOnRead;
    }

    public void setRedirectOnWriteEnabled(boolean redirect) {
        this._doRedirectOnWrite = redirect;
    }

    public boolean isRedirectOnWriteEnabled() {
        return this._doRedirectOnWrite;
    }

    public void setOverwriteAllowed(boolean allowed) {
        this._isOverwriteAllowed = allowed;
    }

    public boolean isOverwriteAllowed() {
        return this._isOverwriteAllowed;
    }

    public void setAnonymousListing(boolean isAllowed) {
        this._isAnonymousListingAllowed = isAllowed;
    }

    public boolean isAnonymousListing() {
        return this._isAnonymousListingAllowed;
    }

    public void setPnfsStub(CellStub stub) {
        this._pnfs = new PnfsHandler(stub);
    }

    public void setPoolStub(CellStub stub) {
        this._poolStub = stub;
    }

    public void setPoolManagerStub(CellStub stub) {
        this._poolManagerStub = stub;
    }

    public void setBillingStub(CellStub stub) {
        this._billingStub = stub;
    }

    public void setMissingFileStrategy(MissingFileStrategy strategy) {
        this._missingFileStrategy = strategy;
    }

    public void setListHandler(ListDirectoryHandler list) {
        this._list = list;
    }

    public void setTemplateResource(org.springframework.core.io.Resource resource) throws IOException {
        this._listingGroup = new STGroupFile(resource.getURL(), "UTF-8", '$', '$');
    }

    public String getStaticContentPath() {
        return this._staticContentPath;
    }

    public void setStaticContentPath(String path) {
        this._staticContentPath = path;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this._executor = executor;
        this._executor.scheduleAtFixedRate((Runnable)new PingMoversTask(this._transfers.values()), 300000L, 300000L, TimeUnit.MILLISECONDS);
    }

    public void setInternalAddress(String host) throws UnknownHostException {
        if (host != null && !host.isEmpty()) {
            InetAddress address = InetAddress.getByName(host);
            if (address.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Wildcard address is not allowed: " + host);
            }
            this._internalAddress = address;
        } else {
            this._internalAddress = InetAddress.getLocalHost();
        }
    }

    public String getInternalAddress() {
        return this._internalAddress.getHostAddress();
    }

    public void getInfo(PrintWriter pw) {
        pw.println("Root path    : " + this.getRootPath());
        pw.println("Allowed paths: " + this.getAllowedPaths());
        pw.println("IO queue     : " + this.getIoQueue());
    }

    public Resource getResource(String host, String path) {
        if (_log.isDebugEnabled()) {
            _log.debug("Resolving " + HttpManager.request().getAbsoluteUrl());
        }
        return this.getResource(this.getFullPath(path));
    }

    public DcacheResource getResource(FsPath path) {
        if (!this.isAllowedPath(path)) {
            return null;
        }
        FsPath requestPath = this.getRequestPath(path);
        boolean haveRetried = false;
        Subject subject = DcacheResourceFactory.getSubject();
        try {
            while (true) {
                try {
                    PnfsHandler pnfs = new PnfsHandler(this._pnfs, subject);
                    EnumSet<FileAttribute> requestedAttributes = EnumSet.copyOf(REQUIRED_ATTRIBUTES);
                    if (DcacheResourceFactory.isDigestRequested()) {
                        requestedAttributes.add(FileAttribute.CHECKSUM);
                    }
                    FileAttributes attributes = pnfs.getFileAttributes(path.toString(), requestedAttributes);
                    return this.getResource(path, attributes);
                }
                catch (FileNotFoundCacheException e) {
                    if (haveRetried) {
                        return null;
                    }
                    switch (this._missingFileStrategy.recommendedAction(subject, path, requestPath)) {
                        case FAIL: {
                            return null;
                        }
                        case RETRY: {
                            haveRetried = true;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (PermissionDeniedCacheException e) {
            throw new UnauthorizedException(e.getMessage(), e, null);
        }
        catch (CacheException e) {
            throw new WebDavException(e.getMessage(), e, null);
        }
    }

    private DcacheResource getResource(FsPath path, FileAttributes attributes) {
        if (attributes.getFileType() == FileType.DIR) {
            return new DcacheDirectoryResource(this, path, attributes);
        }
        return new DcacheFileResource(this, path, attributes);
    }

    public boolean shouldRedirect(Request request) {
        switch (request.getMethod()) {
            case GET: {
                return this.isRedirectOnReadEnabled();
            }
            case PUT: {
                boolean expects100Continue = Objects.equal((Object)request.getExpectHeader(), (Object)"100-continue");
                return this.isRedirectOnWriteEnabled() && expects100Continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DcacheResource createFile(FsPath path, InputStream inputStream, Long length) throws CacheException, InterruptedException, IOException, URISyntaxException {
        Subject subject = DcacheResourceFactory.getSubject();
        ProxyThroughGftpWriteTransfer transfer = new ProxyThroughGftpWriteTransfer(this._pnfs, subject, path);
        this._transfers.put((int)transfer.getSessionId(), transfer);
        try {
            boolean success = false;
            transfer.createNameSpaceEntry();
            try {
                transfer.setLength(length);
                transfer.openServerChannel();
                try {
                    transfer.selectPoolAndStartMover(this._ioQueue, this._retryPolicy);
                    transfer.relayData(inputStream);
                }
                finally {
                    transfer.killMover(this._killTimeout);
                    transfer.closeServerChannel();
                }
                transfer.notifyBilling(0, "");
                success = true;
            }
            finally {
                if (!success) {
                    transfer.deleteNameSpaceEntry();
                }
            }
        }
        catch (CacheException e) {
            transfer.notifyBilling(e.getRc(), e.getMessage());
            throw e;
        }
        catch (InterruptedException e) {
            transfer.notifyBilling(10011, "Transfer interrupted");
            throw e;
        }
        catch (IOException | RuntimeException e) {
            transfer.notifyBilling(10011, e.toString());
            throw e;
        }
        finally {
            this._transfers.remove((int)transfer.getSessionId());
        }
        return this.getResource(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWriteUrl(FsPath path, Long length) throws CacheException, InterruptedException, URISyntaxException {
        Subject subject = DcacheResourceFactory.getSubject();
        String uri = null;
        WriteTransfer transfer = new WriteTransfer(this._pnfs, subject, path);
        this._transfers.put((int)transfer.getSessionId(), transfer);
        try {
            transfer.createNameSpaceEntry();
            try {
                transfer.setLength(length);
                transfer.selectPoolAndStartMover(this._ioQueue, this._retryPolicy);
                uri = (String)transfer.waitForRedirect(this._moverTimeout);
                if (uri == null) {
                    throw new TimeoutCacheException("Server is busy (internal timeout)");
                }
                transfer.setStatus("Mover " + transfer.getPool() + "/" + transfer.getMoverId() + ": Waiting for completion");
            }
            finally {
                if (uri == null) {
                    transfer.deleteNameSpaceEntry();
                }
            }
        }
        catch (CacheException e) {
            transfer.notifyBilling(e.getRc(), e.getMessage());
            throw e;
        }
        catch (InterruptedException e) {
            transfer.notifyBilling(10011, "Transfer interrupted");
            throw e;
        }
        catch (RuntimeException e) {
            transfer.notifyBilling(10011, e.toString());
            throw e;
        }
        finally {
            if (uri == null) {
                this._transfers.remove((int)transfer.getSessionId());
            }
        }
        return uri;
    }

    public void readFile(FsPath path, PnfsId pnfsid, OutputStream outputStream, Range range) throws CacheException, InterruptedException, IOException, URISyntaxException {
        ReadTransfer transfer = this.beginRead(path, pnfsid);
        try {
            transfer.relayData(outputStream, range);
        }
        catch (CacheException e) {
            transfer.notifyBilling(e.getRc(), e.getMessage());
            throw e;
        }
        catch (InterruptedException e) {
            transfer.notifyBilling(10011, "Transfer interrupted");
            throw e;
        }
        catch (IOException | RuntimeException e) {
            transfer.notifyBilling(10011, e.toString());
            throw e;
        }
        finally {
            this._transfers.remove((int)transfer.getSessionId());
        }
    }

    public List<DcacheResource> list(final FsPath path) throws InterruptedException, CacheException {
        if (!this._isAnonymousListingAllowed && Subjects.isNobody((Subject)DcacheResourceFactory.getSubject())) {
            throw new PermissionDeniedCacheException("Access denied");
        }
        final ArrayList<DcacheResource> result = new ArrayList<DcacheResource>();
        DirectoryListPrinter printer = new DirectoryListPrinter(){

            public Set<FileAttribute> getRequiredAttributes() {
                return REQUIRED_ATTRIBUTES;
            }

            public void print(FsPath dir, FileAttributes dirAttr, DirectoryEntry entry) {
                result.add(DcacheResourceFactory.this.getResource(new FsPath(path, entry.getName()), entry.getFileAttributes()));
            }
        };
        this._list.printDirectory(DcacheResourceFactory.getSubject(), printer, path, null, Ranges.all());
        return result;
    }

    public void list(FsPath path, Writer out) throws InterruptedException, CacheException, IOException, URISyntaxException {
        if (!this._isAnonymousListingAllowed && Subjects.isNobody((Subject)DcacheResourceFactory.getSubject())) {
            throw new PermissionDeniedCacheException("Access denied");
        }
        Request request = HttpManager.request();
        String requestPath = new URI(request.getAbsoluteUrl()).getPath();
        String[] base = (String[])Iterables.toArray((Iterable)PATH_SPLITTER.split((CharSequence)requestPath), String.class);
        final ST t = this._listingGroup.getInstanceOf("page");
        t.add("path", Arrays.asList(UrlPathWrapper.forPaths(base)));
        t.add("static", (Object)this._staticContentPath);
        t.add("subject", (Object)new SubjectWrapper(DcacheResourceFactory.getSubject()));
        t.add("base", (Object)UrlPathWrapper.forEmptyPath());
        DirectoryListPrinter printer = new DirectoryListPrinter(){

            public Set<FileAttribute> getRequiredAttributes() {
                return EnumSet.of(FileAttribute.MODIFICATION_TIME, FileAttribute.TYPE, FileAttribute.SIZE);
            }

            public void print(FsPath dir, FileAttributes dirAttr, DirectoryEntry entry) {
                FileAttributes attr = entry.getFileAttributes();
                Date mtime = new Date(attr.getModificationTime());
                UrlPathWrapper name = UrlPathWrapper.forPath(entry.getName());
                t.addAggr("files.{name,isDirectory,mtime,size}", new Object[]{name, attr.getFileType() == FileType.DIR, mtime, attr.getSize()});
            }
        };
        this._list.printDirectory(DcacheResourceFactory.getSubject(), printer, path, null, Ranges.all());
        t.write((STWriter)new AutoIndentWriter(out));
        out.flush();
    }

    public void deleteFile(PnfsId pnfsid, FsPath path) throws CacheException {
        PnfsHandler pnfs = new PnfsHandler(this._pnfs, DcacheResourceFactory.getSubject());
        pnfs.deletePnfsEntry(pnfsid, path.toString(), EnumSet.of(FileType.REGULAR, FileType.LINK));
        this.sendRemoveInfoToBilling(path);
    }

    private void sendRemoveInfoToBilling(FsPath path) {
        try {
            DoorRequestInfoMessage infoRemove = new DoorRequestInfoMessage(this.getCellAddress().toString(), "remove");
            Subject subject = DcacheResourceFactory.getSubject();
            infoRemove.setSubject(subject);
            infoRemove.setPath(path.toString());
            infoRemove.setClient(Subjects.getOrigin((Subject)subject).getAddress().getHostAddress());
            this._billingStub.send((Serializable)infoRemove);
        }
        catch (NoRouteToCellException e) {
            _log.error("Cannot send remove message to billing: {}", (Object)e.getMessage());
        }
    }

    public void deleteDirectory(PnfsId pnfsid, FsPath path) throws CacheException {
        PnfsHandler pnfs = new PnfsHandler(this._pnfs, DcacheResourceFactory.getSubject());
        pnfs.deletePnfsEntry(pnfsid, path.toString(), EnumSet.of(FileType.DIR));
    }

    public DcacheDirectoryResource makeDirectory(FileAttributes parent, FsPath path) throws CacheException {
        PnfsHandler pnfs = new PnfsHandler(this._pnfs, DcacheResourceFactory.getSubject());
        PnfsCreateEntryMessage reply = pnfs.createPnfsDirectory(path.toString());
        FileAttributes attributes = pnfs.getFileAttributes(reply.getPnfsId(), REQUIRED_ATTRIBUTES);
        return new DcacheDirectoryResource(this, path, attributes);
    }

    public void move(PnfsId pnfsId, FsPath newPath) throws CacheException {
        PnfsHandler pnfs = new PnfsHandler(this._pnfs, DcacheResourceFactory.getSubject());
        pnfs.renameEntry(pnfsId, newPath.toString());
    }

    public String getReadUrl(FsPath path, PnfsId pnfsid) throws CacheException, InterruptedException, URISyntaxException {
        return (String)this.beginRead(path, pnfsid).getRedirect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadTransfer beginRead(FsPath path, PnfsId pnfsid) throws CacheException, InterruptedException, URISyntaxException {
        Subject subject = DcacheResourceFactory.getSubject();
        String uri = null;
        ReadTransfer transfer = new ReadTransfer(this._pnfs, subject, path, pnfsid);
        transfer.setIsChecksumNeeded(DcacheResourceFactory.isDigestRequested());
        this._transfers.put((int)transfer.getSessionId(), transfer);
        try {
            transfer.readNameSpaceEntry();
            try {
                transfer.selectPoolAndStartMover(this._ioQueue, this._retryPolicy);
                uri = (String)transfer.waitForRedirect(this._moverTimeout);
                if (uri == null) {
                    throw new TimeoutCacheException("Server is busy (internal timeout)");
                }
            }
            finally {
                transfer.setStatus(null);
            }
            transfer.setStatus("Mover " + transfer.getPool() + "/" + transfer.getMoverId() + ": Waiting for completion");
        }
        catch (CacheException e) {
            transfer.notifyBilling(e.getRc(), e.getMessage());
            throw e;
        }
        catch (InterruptedException e) {
            transfer.notifyBilling(10011, "Transfer interrupted");
            throw e;
        }
        catch (RuntimeException e) {
            transfer.notifyBilling(10011, e.toString());
            throw e;
        }
        finally {
            if (uri == null) {
                this._transfers.remove((int)transfer.getSessionId());
            }
        }
        return transfer;
    }

    public void messageArrived(CellMessage envelope, HttpDoorUrlInfoMessage message) {
        HttpTransfer transfer = this._transfers.get((int)message.getId());
        if (transfer != null) {
            transfer.redirect(message.getUrl());
        }
    }

    public void messageArrived(DoorTransferFinishedMessage message) {
        Transfer transfer = (Transfer)this._transfers.get((int)message.getId());
        if (transfer != null) {
            transfer.finished(message);
        }
    }

    private FsPath getFullPath(String path) {
        return new FsPath(new FsPath[]{this._rootPath, new FsPath(path)});
    }

    private FsPath getRequestPath(FsPath internalPath) {
        return this._rootPath.relativize(internalPath);
    }

    private boolean isAllowedPath(FsPath path) {
        for (FsPath allowedPath : this._allowedPaths) {
            if (!path.startsWith(allowedPath)) continue;
            return true;
        }
        return false;
    }

    private static Subject getSubject() {
        return Subject.getSubject(AccessController.getContext());
    }

    private static URI getLocation() throws URISyntaxException {
        URI uri = new URI(HttpManager.request().getAbsoluteUrl());
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
    }

    public Object ac_get_children(Args args) {
        boolean binary = args.hasOption("binary");
        if (binary) {
            String[] list = new String[]{this.getCellName()};
            return new LoginManagerChildrenInfo(this.getCellName(), this.getCellDomainName(), list);
        }
        return this.getCellName();
    }

    public Object ac_get_door_info(Args args) {
        ArrayList<IoDoorEntry> transfers = new ArrayList<IoDoorEntry>();
        for (Transfer transfer : this._transfers.values()) {
            transfers.add(transfer.getIoDoorEntry());
        }
        IoDoorInfo doorInfo = new IoDoorInfo(this.getCellName(), this.getCellDomainName());
        doorInfo.setProtocol("HTTP", "1.1");
        doorInfo.setOwner("");
        doorInfo.setProcess("");
        doorInfo.setIoDoorEntries(transfers.toArray(new IoDoorEntry[transfers.size()]));
        return args.hasOption("binary") ? doorInfo : doorInfo.toString();
    }

    private void initializeTransfer(HttpTransfer transfer, Subject subject) throws URISyntaxException {
        transfer.setLocation(DcacheResourceFactory.getLocation());
        transfer.setCellName(this.getCellName());
        transfer.setDomainName(this.getCellDomainName());
        transfer.setPoolManagerStub(this._poolManagerStub);
        transfer.setPoolStub(this._poolStub);
        transfer.setBillingStub(this._billingStub);
        transfer.setClientAddress(new InetSocketAddress(Subjects.getOrigin((Subject)subject).getAddress(), 0));
        transfer.setOverwriteAllowed(this._isOverwriteAllowed);
    }

    private static boolean isDigestRequested() {
        return HttpManager.request().getHeaders().containsKey("Want-Digest");
    }

    private class ProxyThroughGftpWriteTransfer
    extends HttpTransfer {
        private ServerSocketChannel _serverChannel;

        public ProxyThroughGftpWriteTransfer(PnfsHandler pnfs, Subject subject, FsPath path) throws URISyntaxException {
            super(pnfs, subject, path);
        }

        public synchronized void openServerChannel() throws IOException {
            this._serverChannel = ServerSocketChannel.open();
            try {
                this._serverChannel.socket().setSoTimeout(DcacheResourceFactory.this._moverTimeout);
                this._serverChannel.socket().bind(new InetSocketAddress(DcacheResourceFactory.this._internalAddress, 0));
            }
            catch (IOException e) {
                this._serverChannel.close();
                this._serverChannel = null;
                throw e;
            }
        }

        public synchronized void closeServerChannel() throws IOException {
            if (this._serverChannel != null) {
                this._serverChannel.close();
                this._serverChannel = null;
            }
        }

        public synchronized ServerSocketChannel getServerChannel() {
            return this._serverChannel;
        }

        @Override
        protected ProtocolInfo getProtocolInfoForPool() {
            ServerSocket socket = this.getServerChannel().socket();
            return new GFtpProtocolInfo(DcacheResourceFactory.RELAY_PROTOCOL_INFO_NAME, 1, 0, (InetSocketAddress)socket.getLocalSocketAddress(), 1, 1, 1, 0, 0L, 0L);
        }

        public void relayData(InputStream inputStream) throws IOException, CacheException, InterruptedException {
            this.setStatus("Mover " + this.getPool() + "/" + this.getMoverId() + ": Waiting for data connection");
            try {
                ServerSocketChannel serverChannel = this.getServerChannel();
                if (serverChannel == null) {
                    throw new AsynchronousCloseException();
                }
                try (OutputStream outputStream = this.getServerChannel().accept().socket().getOutputStream();){
                    this.closeServerChannel();
                    this.setStatus("Mover " + this.getPool() + "/" + this.getMoverId() + ": Receiving data");
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                    outputStream.flush();
                }
                if (!this.waitForMover(DcacheResourceFactory.this._transferConfirmationTimeout)) {
                    throw new CacheException("Missing transfer confirmation from pool");
                }
            }
            catch (AsynchronousCloseException e) {
                this.waitForMover(0L);
                throw new IllegalStateException("Server channel is not open");
            }
            catch (SocketTimeoutException e) {
                throw new TimeoutCacheException("Server is busy (internal timeout)");
            }
            finally {
                this.setStatus(null);
            }
        }

        public synchronized void finished(CacheException error) {
            super.finished(error);
            if (this._serverChannel != null) {
                try {
                    this._serverChannel.close();
                }
                catch (IOException e) {
                    _log.error("Failed to close pool connection: " + e.getMessage());
                }
            }
        }

        public void setLength(Long length) {
            if (length != null) {
                super.setLength(length.longValue());
            }
        }
    }

    private class WriteTransfer
    extends HttpTransfer {
        public WriteTransfer(PnfsHandler pnfs, Subject subject, FsPath path) throws URISyntaxException {
            super(pnfs, subject, path);
        }

        public void setLength(Long length) {
            if (length != null) {
                super.setLength(length.longValue());
            }
        }

        public synchronized void finished(CacheException error) {
            super.finished(error);
            DcacheResourceFactory.this._transfers.remove((int)this.getSessionId());
            if (error == null) {
                this.notifyBilling(0, "");
            } else {
                this.notifyBilling(error.getRc(), error.getMessage());
            }
        }
    }

    private class ReadTransfer
    extends HttpTransfer {
        public ReadTransfer(PnfsHandler pnfs, Subject subject, FsPath path, PnfsId pnfsid) throws URISyntaxException {
            super(pnfs, subject, path);
            this.setPnfsId(pnfsid);
        }

        public void setIsChecksumNeeded(boolean isChecksumNeeded) {
            if (isChecksumNeeded) {
                this.setAdditionalAttributes(Collections.singleton(FileAttribute.CHECKSUM));
            } else {
                this.setAdditionalAttributes(Collections.emptySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void relayData(OutputStream outputStream, Range range) throws IOException, CacheException, InterruptedException {
            this.setStatus("Mover " + this.getPool() + "/" + this.getMoverId() + ": Opening data connection");
            try {
                URL url = new URL((String)this.getRedirect());
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                try {
                    connection.setRequestProperty("Connection", "Close");
                    if (range != null) {
                        connection.addRequestProperty("Range", String.format("bytes=%d-%d", range.getStart(), range.getFinish()));
                    }
                    connection.connect();
                    try (InputStream inputStream = connection.getInputStream();){
                        this.setStatus("Mover " + this.getPool() + "/" + this.getMoverId() + ": Sending data");
                        ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                        outputStream.flush();
                    }
                }
                finally {
                    connection.disconnect();
                }
                if (!this.waitForMover(DcacheResourceFactory.this._transferConfirmationTimeout)) {
                    throw new CacheException("Missing transfer confirmation from pool");
                }
            }
            catch (SocketTimeoutException e) {
                throw new TimeoutCacheException("Server is busy (internal timeout)");
            }
            finally {
                this.setStatus(null);
            }
        }

        public synchronized void finished(CacheException error) {
            super.finished(error);
            DcacheResourceFactory.this._transfers.remove((int)this.getSessionId());
            if (error == null) {
                this.notifyBilling(0, "");
            } else {
                this.notifyBilling(error.getRc(), error.getMessage());
            }
        }
    }

    private class HttpTransfer
    extends RedirectedTransfer<String> {
        private URI _location;

        public HttpTransfer(PnfsHandler pnfs, Subject subject, FsPath path) throws URISyntaxException {
            super(pnfs, subject, path);
            DcacheResourceFactory.this.initializeTransfer(this, subject);
        }

        protected ProtocolInfo createProtocolInfo() {
            HttpProtocolInfo protocolInfo = new HttpProtocolInfo(DcacheResourceFactory.PROTOCOL_INFO_NAME, 1, 1, this.getClientAddress(), this.getCellName(), DcacheResourceFactory.this.getCellDomainName(), this._path.toString(), this._location);
            protocolInfo.setSessionId((int)this.getSessionId());
            return protocolInfo;
        }

        protected ProtocolInfo getProtocolInfoForPoolManager() {
            return this.createProtocolInfo();
        }

        protected ProtocolInfo getProtocolInfoForPool() {
            return this.createProtocolInfo();
        }

        public void setLocation(URI location) {
            this._location = location;
        }
    }
}

