/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.FsPath;
import io.milton.http.Auth;
import io.milton.http.LockInfo;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.Request;
import io.milton.http.exceptions.ConflictException;
import io.milton.resource.CollectionResource;
import io.milton.resource.LockableResource;
import io.milton.resource.MoveableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.util.Date;
import java.util.UUID;
import org.dcache.vehicles.FileAttributes;
import org.dcache.webdav.DcacheDirectoryResource;
import org.dcache.webdav.DcacheResourceFactory;

public class DcacheResource
implements Comparable<DcacheResource>,
Resource,
PropFindableResource,
MoveableResource,
LockableResource {
    private static final LockToken NO_LOCK = null;
    protected final DcacheResourceFactory _factory;
    protected final FileAttributes _attributes;
    protected FsPath _path;

    public DcacheResource(DcacheResourceFactory factory, FsPath path, FileAttributes attributes) {
        this._factory = factory;
        this._path = path;
        this._attributes = attributes;
    }

    public Object authenticate(String user, String password) {
        return user;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Date getModifiedDate() {
        return new Date(this._attributes.getModificationTime());
    }

    public Date getCreateDate() {
        return new Date(this._attributes.getCreationTime());
    }

    public String getName() {
        return this._path.getName();
    }

    public String getRealm() {
        return "dCache";
    }

    public String getUniqueId() {
        return this._attributes.getPnfsId().toString();
    }

    @Override
    public int compareTo(DcacheResource that) {
        return this.getName().compareTo(that.getName());
    }

    public void moveTo(CollectionResource newParent, String name) throws ConflictException {
        if (!(newParent instanceof DcacheDirectoryResource)) {
            throw new RuntimeException("Destination is an unknown type. Must be a DcacheDirectoryResource, is a: " + newParent.getClass());
        }
        try {
            DcacheDirectoryResource directory = (DcacheDirectoryResource)newParent;
            FsPath newPath = new FsPath(directory._path, name);
            this._factory.move(this._attributes.getPnfsId(), newPath);
            this._path = newPath;
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    protected LockToken createNullLock() {
        return new LockToken(UUID.randomUUID().toString(), new LockInfo(LockInfo.LockScope.SHARED, LockInfo.LockType.WRITE, "", LockInfo.LockDepth.ZERO), new LockTimeout(Long.valueOf(0L)));
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo) {
        return LockResult.success((LockToken)this.createNullLock());
    }

    public LockResult refreshLock(String token) {
        return LockResult.success((LockToken)this.createNullLock());
    }

    public void unlock(String tokenId) {
    }

    public LockToken getCurrentLock() {
        return NO_LOCK;
    }
}

