/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.NotInTrashCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import io.milton.http.Auth;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.DeletableResource;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.net.FileNameMap;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Map;
import org.dcache.namespace.FileAttribute;
import org.dcache.util.Checksums;
import org.dcache.vehicles.FileAttributes;
import org.dcache.webdav.DcacheResource;
import org.dcache.webdav.DcacheResourceFactory;
import org.dcache.webdav.ForbiddenException;
import org.dcache.webdav.UnauthorizedException;
import org.dcache.webdav.WebDavException;

public class DcacheFileResource
extends DcacheResource
implements GetableResource,
DeletableResource {
    private static final FileNameMap MIME_TYPE_MAP = URLConnection.getFileNameMap();

    public DcacheFileResource(DcacheResourceFactory factory, FsPath path, FileAttributes attributes) {
        super(factory, path, attributes);
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException {
        try {
            this._factory.readFile(new FsPath(this._path), this._attributes.getPnfsId(), out, range);
        }
        catch (PermissionDeniedCacheException e) {
            throw new NotAuthorizedException((Resource)this);
        }
        catch (FileNotFoundCacheException | NotInTrashCacheException e) {
            throw new ForbiddenException(e.getMessage(), e, this);
        }
        catch (CacheException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
        catch (InterruptedException e) {
            throw new WebDavException("Transfer was interrupted", e, this);
        }
        catch (URISyntaxException e) {
            throw new WebDavException("Invalid request URI: " + e.getMessage(), e, this);
        }
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public String getContentType(String accepts) {
        return MIME_TYPE_MAP.getContentTypeFor(this._path.toString());
    }

    public Long getContentLength() {
        return this._attributes.getSize();
    }

    @Override
    public String checkRedirect(Request request) {
        try {
            if (this._factory.shouldRedirect(request)) {
                return this._factory.getReadUrl(this._path, this._attributes.getPnfsId());
            }
            return null;
        }
        catch (PermissionDeniedCacheException e) {
            throw new UnauthorizedException(e.getMessage(), e, this);
        }
        catch (CacheException | InterruptedException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
        catch (URISyntaxException e) {
            throw new WebDavException("Invalid request URI: " + e.getMessage(), e, this);
        }
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        try {
            this._factory.deleteFile(this._attributes.getPnfsId(), this._path);
        }
        catch (PermissionDeniedCacheException e) {
            throw new NotAuthorizedException((Resource)this);
        }
        catch (CacheException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
    }

    public String getRfc3230Digest() {
        if (this._attributes.isDefined(FileAttribute.CHECKSUM)) {
            return Checksums.rfc3230Encoded((Collection)this._attributes.getChecksums());
        }
        return "";
    }
}

