/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.webdav;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileExistsCacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PermissionDeniedCacheException;
import io.milton.http.Auth;
import io.milton.http.HttpManager;
import io.milton.http.LockInfo;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import io.milton.resource.DeletableResource;
import io.milton.resource.GetableResource;
import io.milton.resource.LockingCollectionResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dcache.vehicles.FileAttributes;
import org.dcache.webdav.DcacheResource;
import org.dcache.webdav.DcacheResourceFactory;
import org.dcache.webdav.RedirectException;
import org.dcache.webdav.UnauthorizedException;
import org.dcache.webdav.WebDavException;

public class DcacheDirectoryResource
extends DcacheResource
implements PutableResource,
GetableResource,
DeletableResource,
MakeCollectionableResource,
LockingCollectionResource {
    public DcacheDirectoryResource(DcacheResourceFactory factory, FsPath path, FileAttributes attributes) {
        super(factory, path, attributes);
    }

    @Override
    public String checkRedirect(Request request) {
        String url = request.getAbsoluteUrl();
        if (request.getMethod() == Request.Method.GET && !url.endsWith("/")) {
            return url + "/";
        }
        return null;
    }

    public Resource child(String childName) {
        FsPath fchild = new FsPath(this._path, childName);
        return this._factory.getResource(fchild);
    }

    public List<? extends Resource> getChildren() {
        try {
            return this._factory.list(this._path);
        }
        catch (FileNotFoundCacheException e) {
            return Collections.emptyList();
        }
        catch (PermissionDeniedCacheException e) {
            throw new UnauthorizedException(e.getMessage(), e, this);
        }
        catch (CacheException | InterruptedException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
    }

    public Resource createNew(String newName, InputStream inputStream, Long length, String contentType) throws IOException, ConflictException, NotAuthorizedException, BadRequestException {
        try {
            FsPath path = new FsPath(this._path, newName);
            if (this._factory.shouldRedirect(HttpManager.request())) {
                throw new RedirectException(this, this._factory.getWriteUrl(path, length));
            }
            return this._factory.createFile(path, inputStream, length);
        }
        catch (PermissionDeniedCacheException e) {
            throw new NotAuthorizedException((Resource)this);
        }
        catch (FileExistsCacheException e) {
            throw new ConflictException((Resource)this);
        }
        catch (CacheException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
        catch (InterruptedException e) {
            throw new WebDavException("Transfer was interrupted", e, this);
        }
        catch (URISyntaxException e) {
            throw new WebDavException("Invalid request URI: " + e.getMessage(), e, this);
        }
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException {
        try {
            this._factory.list(this._path, new OutputStreamWriter(out, "UTF-8"));
        }
        catch (PermissionDeniedCacheException e) {
            throw new NotAuthorizedException((Resource)this);
        }
        catch (CacheException | InterruptedException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This should not happen as UTF-8 is a required encoding for JVM", e);
        }
        catch (URISyntaxException e) {
            throw new WebDavException("Badly formed URI: " + e.getMessage(), this);
        }
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public String getContentType(String accepts) {
        return "text/html; charset=utf-8";
    }

    public Long getContentLength() {
        return null;
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        try {
            this._factory.deleteDirectory(this._attributes.getPnfsId(), this._path);
        }
        catch (PermissionDeniedCacheException e) {
            throw new NotAuthorizedException((Resource)this);
        }
        catch (CacheException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
    }

    public CollectionResource createCollection(String newName) throws NotAuthorizedException, ConflictException {
        try {
            return this._factory.makeDirectory(this._attributes, new FsPath(this._path, newName));
        }
        catch (PermissionDeniedCacheException e) {
            throw new NotAuthorizedException((Resource)this);
        }
        catch (CacheException e) {
            throw new WebDavException(e.getMessage(), e, this);
        }
    }

    public LockToken createAndLock(String name, LockTimeout timeout, LockInfo lockInfo) {
        return this.createNullLock();
    }
}

