/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.Set;
import org.dcache.auth.util.X509Utils;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.util.Preconditions;
import org.globus.gsi.jaas.GlobusPrincipal;

public class X509Plugin
implements GPlazmaAuthenticationPlugin {
    public X509Plugin(Properties properties) {
    }

    public void authenticate(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> identifiedPrincipals) throws AuthenticationException {
        boolean found = false;
        for (Object credential : publicCredentials) {
            if (!(credential instanceof X509Certificate[])) continue;
            X509Certificate[] chain = (X509Certificate[])credential;
            String dn = X509Utils.getSubjectFromX509Chain((X509Certificate[])chain, (boolean)false);
            identifiedPrincipals.add((Principal)new GlobusPrincipal(dn));
            found = true;
        }
        Preconditions.checkAuthentication((boolean)found, (String)"no X509 certificate chain");
    }
}

