/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dcache.gplazma.plugins.LineParser;
import org.dcache.gplazma.plugins.LineSource;
import org.dcache.gplazma.plugins.MapPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SourceBackedPredicateMap<TKey, TValue> {
    private static final Logger _log = LoggerFactory.getLogger(SourceBackedPredicateMap.class);
    private final Map<MapPredicate<TKey>, TValue> _predicateValueMap = new LinkedHashMap<MapPredicate<TKey>, TValue>();
    private final LineSource _source;
    private final LineParser<? extends MapPredicate<TKey>, TValue> _parser;

    protected SourceBackedPredicateMap(LineSource source, LineParser<? extends MapPredicate<TKey>, TValue> parser) {
        this._source = source;
        this._parser = parser;
    }

    public synchronized List<TValue> getValuesForPredicatesMatching(TKey key) {
        if (this._source.hasChanged()) {
            try {
                _log.info("Source changed. Recreating map.");
                this.createMapFromData(this._source.getContent());
            }
            catch (IOException e) {
                _log.error("Error creating map.", (Throwable)e);
                return Collections.emptyList();
            }
        }
        LinkedList<TValue> result = new LinkedList<TValue>();
        for (Map.Entry<MapPredicate<TKey>, TValue> predicateEntry : this._predicateValueMap.entrySet()) {
            if (!predicateEntry.getKey().matches(key)) continue;
            result.add(predicateEntry.getValue());
        }
        return result;
    }

    private synchronized void createMapFromData(List<String> data) {
        this._predicateValueMap.clear();
        for (String line : data) {
            Map.Entry<MapPredicate<TKey>, TValue> entry = this._parser.accept(line);
            if (entry == null) continue;
            this._predicateValueMap.put(entry.getKey(), entry.getValue());
        }
    }
}

