/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.dcache.gplazma.plugins.LineSource;

class FileLineSource
implements LineSource {
    private final File _file;
    private final long _minCheckInterval;
    private long _lastRefresh;

    public FileLineSource(String filepath, long minCheckIntervalMillis) throws FileNotFoundException {
        this._file = new File(filepath);
        this._minCheckInterval = minCheckIntervalMillis;
        if (!this._file.exists()) {
            throw new FileNotFoundException(String.format("File '%s' not found.", filepath));
        }
    }

    @Override
    public boolean hasChanged() {
        return this._lastRefresh + this._minCheckInterval < System.currentTimeMillis() && this._lastRefresh < this._file.lastModified();
    }

    @Override
    public List<String> getContent() throws IOException {
        List result = Files.readLines((File)this._file, (Charset)Charsets.UTF_8);
        this._lastRefresh = System.currentTimeMillis();
        return result;
    }
}

