/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.database.typeconversion.TypeConverter;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.ServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConverterFactory {
    private static TypeConverterFactory instance;
    private Set<TypeConverter> allConverters = new HashSet<TypeConverter>();

    public static TypeConverterFactory getInstance() {
        if (instance == null) {
            instance = new TypeConverterFactory();
        }
        return instance;
    }

    private TypeConverterFactory() {
        try {
            for (Class converterClass : ServiceLocator.getInstance().findClasses(TypeConverter.class)) {
                this.register((TypeConverter)converterClass.newInstance());
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public TypeConverter findTypeConverter(Database database) {
        TreeSet<TypeConverter> converters = new TreeSet<TypeConverter>(new Comparator<TypeConverter>(){

            @Override
            public int compare(TypeConverter o1, TypeConverter o2) {
                return Integer.valueOf(o1.getPriority()).compareTo(o2.getPriority());
            }
        });
        for (TypeConverter converter : this.allConverters) {
            if (!converter.supports(database)) continue;
            converters.add(converter);
        }
        return (TypeConverter)converters.last();
    }

    public void register(TypeConverter typeConverter) {
        this.allConverters.add(typeConverter);
    }

    public void register(Class<? extends TypeConverter> typeConverterClass) {
        try {
            this.allConverters.add(typeConverterClass.newInstance());
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }
}

