/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.vehicles;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsMessage;
import java.util.Set;
import org.dcache.namespace.FileAttribute;
import org.dcache.vehicles.FileAttributes;

public class PnfsGetFileAttributes
extends PnfsMessage {
    private static final long serialVersionUID = -6750531802534981651L;
    protected FileAttributes _fileAttributes;
    protected Set<FileAttribute> _attributes;

    public PnfsGetFileAttributes(PnfsId pnfsid, Set<FileAttribute> attr) {
        super(pnfsid);
        this._attributes = attr;
        this.setReplyRequired(true);
    }

    public PnfsGetFileAttributes(String path, Set<FileAttribute> attr) {
        this.setPnfsPath(path);
        this._attributes = attr;
        this.setReplyRequired(true);
    }

    public void setFileAttributes(FileAttributes fileAttributes) {
        this._fileAttributes = fileAttributes;
    }

    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    public Set<FileAttribute> getRequestedAttributes() {
        return this._attributes;
    }

    @Override
    public boolean invalidates(Message message) {
        return false;
    }

    @Override
    public boolean fold(Message message) {
        if (message instanceof PnfsGetFileAttributes) {
            PnfsId pnfsId = this.getPnfsId();
            String path = this.getPnfsPath();
            Set<FileAttribute> requested = this.getRequestedAttributes();
            PnfsGetFileAttributes other = (PnfsGetFileAttributes)message;
            if ((pnfsId == null || pnfsId.equals(other.getPnfsId())) && (path == null || path.equals(other.getPnfsPath())) && this.getSubject().equals(other.getSubject()) && other.getRequestedAttributes().containsAll(requested)) {
                this.setPnfsId(other.getPnfsId());
                this.setPnfsPath(other.getPnfsPath());
                this.setFileAttributes(other.getFileAttributes());
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + ";" + (this._fileAttributes == null ? "[noMetaData]" : this._fileAttributes.toString());
    }
}

