/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.vehicles;

import com.google.common.base.Objects;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.StorageInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.dcache.acl.ACL;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.util.Checksum;

public class FileAttributes
implements Serializable {
    private static final long serialVersionUID = -3689129805631724432L;
    private Set<FileAttribute> _definedAttributes = EnumSet.noneOf(FileAttribute.class);
    private ACL _acl;
    private long _size;
    private long _creationTime;
    private long _atime;
    private long _mtime;
    private Set<Checksum> _checksums;
    private int _owner;
    private int _group;
    private int _mode;
    private AccessLatency _accessLatency;
    private RetentionPolicy _retentionPolicy;
    private FileType _fileType;
    private Collection<String> _locations;
    private Map<String, String> _flags;
    private PnfsId _pnfsId;
    private StorageInfo _storageInfo;

    private void guard(FileAttribute attribute) throws IllegalStateException {
        if (!this._definedAttributes.contains((Object)attribute)) {
            throw new IllegalStateException("Attribute is not defined: " + (Object)((Object)attribute));
        }
    }

    private void define(FileAttribute attribute) {
        this._definedAttributes.add(attribute);
    }

    public boolean isUndefined(FileAttribute attribute) {
        return !this._definedAttributes.contains((Object)attribute);
    }

    public boolean isDefined(FileAttribute attribute) {
        return this._definedAttributes.contains((Object)attribute);
    }

    public boolean isDefined(Set<FileAttribute> attributes) {
        return this._definedAttributes.containsAll(attributes);
    }

    public Set<FileAttribute> getDefinedAttributes() {
        return this._definedAttributes;
    }

    public AccessLatency getAccessLatency() {
        this.guard(FileAttribute.ACCESS_LATENCY);
        return this._accessLatency;
    }

    public long getAccessTime() {
        this.guard(FileAttribute.ACCESS_TIME);
        return this._atime;
    }

    public ACL getAcl() {
        this.guard(FileAttribute.ACL);
        return this._acl;
    }

    public Set<Checksum> getChecksums() {
        this.guard(FileAttribute.CHECKSUM);
        return this._checksums;
    }

    public FileType getFileType() {
        this.guard(FileAttribute.TYPE);
        return this._fileType;
    }

    public int getGroup() {
        this.guard(FileAttribute.OWNER_GROUP);
        return this._group;
    }

    public int getMode() {
        this.guard(FileAttribute.MODE);
        return this._mode;
    }

    public long getCreationTime() {
        this.guard(FileAttribute.CREATION_TIME);
        return this._creationTime;
    }

    public long getModificationTime() {
        this.guard(FileAttribute.MODIFICATION_TIME);
        return this._mtime;
    }

    public int getOwner() {
        this.guard(FileAttribute.OWNER);
        return this._owner;
    }

    public RetentionPolicy getRetentionPolicy() {
        this.guard(FileAttribute.RETENTION_POLICY);
        return this._retentionPolicy;
    }

    public long getSize() {
        this.guard(FileAttribute.SIZE);
        return this._size;
    }

    public PnfsId getPnfsId() {
        this.guard(FileAttribute.PNFSID);
        return this._pnfsId;
    }

    public StorageInfo getStorageInfo() {
        this.guard(FileAttribute.STORAGEINFO);
        return this._storageInfo;
    }

    public void setAccessTime(long atime) {
        this.define(FileAttribute.ACCESS_TIME);
        this._atime = atime;
    }

    public void setAccessLatency(AccessLatency accessLatency) {
        this.define(FileAttribute.ACCESS_LATENCY);
        this._accessLatency = accessLatency;
    }

    public void setAcl(ACL acl) {
        this.define(FileAttribute.ACL);
        this._acl = acl;
    }

    public void setChecksums(Set<Checksum> checksums) {
        this.define(FileAttribute.CHECKSUM);
        this._checksums = checksums;
    }

    public void setFileType(FileType fileType) {
        this.define(FileAttribute.TYPE);
        this._fileType = fileType;
    }

    public void setGroup(int group) {
        this.define(FileAttribute.OWNER_GROUP);
        this._group = group;
    }

    public void setMode(int mode) {
        this.define(FileAttribute.MODE);
        this._mode = mode;
    }

    public void setCreationTime(long creationTime) {
        this.define(FileAttribute.CREATION_TIME);
        this._creationTime = creationTime;
    }

    public void setModificationTime(long mtime) {
        this.define(FileAttribute.MODIFICATION_TIME);
        this._mtime = mtime;
    }

    public void setOwner(int owner) {
        this.define(FileAttribute.OWNER);
        this._owner = owner;
    }

    public void setRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.define(FileAttribute.RETENTION_POLICY);
        this._retentionPolicy = retentionPolicy;
    }

    public void setSize(long size) {
        this.define(FileAttribute.SIZE);
        this._size = size;
    }

    public void setLocations(Collection<String> pools) {
        this.define(FileAttribute.LOCATIONS);
        this._locations = pools;
    }

    public Collection<String> getLocations() {
        this.guard(FileAttribute.LOCATIONS);
        return this._locations;
    }

    public Map<String, String> getFlags() {
        this.guard(FileAttribute.FLAGS);
        return this._flags;
    }

    public void setFlags(Map<String, String> flags) {
        this.define(FileAttribute.FLAGS);
        this._flags = flags;
    }

    public void setPnfsId(PnfsId pnfsId) {
        this.define(FileAttribute.PNFSID);
        this._pnfsId = pnfsId;
    }

    public void setStorageInfo(StorageInfo storageInfo) {
        this.define(FileAttribute.STORAGEINFO);
        this._storageInfo = storageInfo;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("defined", this._definedAttributes).add("acl", (Object)this._acl).add("size", this._size).add("creationTime", this._creationTime).add("atime", this._atime).add("mtime", this._mtime).add("checksums", this._checksums).add("owner", this._owner).add("group", this._group).add("mode", this._mode).add("accessLatency", (Object)this._accessLatency).add("retentionPolicy", (Object)this._retentionPolicy).add("fileType", (Object)this._fileType).add("locations", this._locations).add("flags", this._flags).add("pnfsId", (Object)this._pnfsId).add("storageInfo", (Object)this._storageInfo).omitNullValues().toString();
    }
}

