/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.list;

import com.google.common.collect.Range;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.TimeoutCacheException;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.CollectionFactory;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.namespace.FileAttribute;
import org.dcache.util.CacheExceptionFactory;
import org.dcache.util.Glob;
import org.dcache.util.list.DirectoryEntry;
import org.dcache.util.list.DirectoryListPrinter;
import org.dcache.util.list.DirectoryListSource;
import org.dcache.util.list.DirectoryStream;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PnfsListDirectoryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDirectoryHandler
implements CellMessageReceiver,
DirectoryListSource {
    private static final Logger _log = LoggerFactory.getLogger(ListDirectoryHandler.class);
    private final PnfsHandler _pnfs;
    private final Map<UUID, Stream> _replies = CollectionFactory.newConcurrentHashMap();

    public ListDirectoryHandler(PnfsHandler pnfs) {
        this._pnfs = pnfs;
    }

    @Override
    public DirectoryStream list(Subject subject, FsPath path, Glob pattern, Range<Integer> range) throws InterruptedException, CacheException {
        return this.list(subject, path, pattern, range, EnumSet.noneOf(FileAttribute.class));
    }

    @Override
    public DirectoryStream list(Subject subject, FsPath path, Glob pattern, Range<Integer> range, Set<FileAttribute> attributes) throws InterruptedException, CacheException {
        String dir = path.toString();
        PnfsListDirectoryMessage msg = new PnfsListDirectoryMessage(dir, pattern, range, attributes);
        UUID uuid = msg.getUUID();
        boolean success = false;
        Stream stream = new Stream(dir, uuid);
        try {
            msg.setSubject(subject);
            this._replies.put(uuid, stream);
            this._pnfs.send(msg);
            stream.waitForMoreEntries();
            success = true;
            Stream stream2 = stream;
            return stream2;
        }
        catch (NoRouteToCellException e) {
            throw new TimeoutCacheException(e.getMessage());
        }
        finally {
            if (!success) {
                this._replies.remove(uuid);
            }
        }
    }

    @Override
    public void printFile(Subject subject, DirectoryListPrinter printer, FsPath path) throws InterruptedException, CacheException {
        PnfsHandler handler = new PnfsHandler(this._pnfs, subject);
        Set<FileAttribute> required = printer.getRequiredAttributes();
        FileAttributes attributes = handler.getFileAttributes(path.toString(), required);
        DirectoryEntry entry = new DirectoryEntry(path.getName(), attributes);
        if (path.isEmpty()) {
            printer.print(null, null, entry);
        } else {
            FileAttributes dirAttr = handler.getFileAttributes(path.getParent().toString(), required);
            printer.print(path.getParent(), dirAttr, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int printDirectory(Subject subject, DirectoryListPrinter printer, FsPath path, Glob glob, Range<Integer> range) throws InterruptedException, CacheException {
        Set<FileAttribute> required = printer.getRequiredAttributes();
        FileAttributes dirAttr = this._pnfs.getFileAttributes(path.toString(), required);
        DirectoryStream stream = this.list(subject, path, glob, range, required);
        try {
            int total = 0;
            for (DirectoryEntry entry : stream) {
                printer.print(path, dirAttr, entry);
                ++total;
            }
            int n = total;
            return n;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new CacheException(10011, "Failed to close directory stream (" + e.getMessage() + ")");
            }
        }
    }

    public void messageArrived(PnfsListDirectoryMessage reply) {
        if (reply.isReply()) {
            try {
                UUID uuid = reply.getUUID();
                Stream stream = reply.isFinal() ? this._replies.remove(uuid) : this._replies.get(uuid);
                if (stream != null) {
                    stream.put(reply);
                } else {
                    _log.warn("Received list result for an unknown request. Directory listing was possibly incomplete.");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public class Stream
    implements DirectoryStream,
    Iterator<DirectoryEntry> {
        private final BlockingQueue<PnfsListDirectoryMessage> _queue = CollectionFactory.newLinkedBlockingQueue();
        private final UUID _uuid;
        private final String _path;
        private boolean _isFinal;
        private Iterator<DirectoryEntry> _iterator;

        public Stream(String path, UUID uuid) {
            this._path = path;
            this._uuid = uuid;
        }

        @Override
        public void close() {
            ListDirectoryHandler.this._replies.remove(this._uuid);
        }

        private void put(PnfsListDirectoryMessage msg) throws InterruptedException {
            this._queue.put(msg);
        }

        private void waitForMoreEntries() throws InterruptedException, CacheException {
            if (this._isFinal) {
                this._iterator = null;
                return;
            }
            PnfsListDirectoryMessage msg = this._queue.poll(ListDirectoryHandler.this._pnfs.getPnfsTimeout(), TimeUnit.MILLISECONDS);
            if (msg == null) {
                throw new CacheException(10006, "Timeout during directory list");
            }
            this._isFinal = msg.isFinal();
            if (msg.getReturnCode() != 0) {
                throw CacheExceptionFactory.exceptionOf(msg);
            }
            this._iterator = msg.getEntries().iterator();
            if (!this._iterator.hasNext()) {
                this.waitForMoreEntries();
            }
        }

        @Override
        public Iterator<DirectoryEntry> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this._iterator == null || !this._iterator.hasNext()) {
                    this.waitForMoreEntries();
                    if (this._iterator == null) {
                        return false;
                    }
                }
            }
            catch (CacheException e) {
                _log.error("Listing of " + this._path + " incomplete: " + e.getMessage());
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            return true;
        }

        @Override
        public DirectoryEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this._iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

