/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.expression;

public enum Token {
    AND("and"),
    DIV("/"),
    DOT("."),
    EQ("=="),
    GE(">="),
    GT(">"),
    LE("<="),
    LT("<"),
    MINUS("-"),
    MOD("%"),
    MULT("*"),
    NE("!="),
    NOT("not"),
    OR("or"),
    PLUS("+"),
    POWER("**"),
    MATCH("=~"),
    NOT_MATCH("!~"),
    IF("?"),
    TRUE("true"),
    FALSE("false"),
    UMINUS(""),
    NUMBER_LITERAL(""),
    STRING_LITERAL(""),
    IDENTIFIER("");

    public final String label;

    private Token(String label) {
        this.label = label;
    }

    public static Token find(String label) {
        for (Token token : Token.values()) {
            if (!token.label.equals(label)) continue;
            return token;
        }
        throw new IllegalArgumentException(label);
    }
}

