/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.expression;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.dcache.util.expression.Expression;
import org.dcache.util.expression.Token;
import org.parboiled.BaseParser;
import org.parboiled.Rule;
import org.parboiled.annotations.BuildParseTree;
import org.parboiled.annotations.Cached;
import org.parboiled.annotations.DontLabel;
import org.parboiled.annotations.SuppressNode;
import org.parboiled.support.Var;

@BuildParseTree
public abstract class ExpressionParser
extends BaseParser<Expression> {
    final Rule AND;
    final Rule COLON;
    final Rule DIV;
    final Rule EQ;
    final Rule GE;
    final Rule GT;
    final Rule LE;
    final Rule LPAR;
    final Rule LT;
    final Rule MATCH;
    final Rule MINUS;
    final Rule MOD;
    final Rule MULT;
    final Rule NE;
    final Rule NOT;
    final Rule NOT_MATCH;
    final Rule OR;
    final Rule PLUS;
    final Rule POWER;
    final Rule QUERY;
    final Rule RPAR;

    public ExpressionParser() {
        this.AND = this.Terminal(Token.AND.label);
        this.COLON = this.Terminal(":");
        this.DIV = this.Terminal(Token.DIV.label);
        this.EQ = this.Terminal(Token.EQ.label);
        this.GE = this.Terminal(Token.GE.label);
        this.GT = this.Terminal(Token.GT.label);
        this.LE = this.Terminal(Token.LE.label);
        this.LPAR = this.Terminal("(");
        this.LT = this.Terminal(Token.LT.label);
        this.MATCH = this.Terminal(Token.MATCH.label);
        this.MINUS = this.Terminal(Token.MINUS.label);
        this.MOD = this.Terminal(Token.MOD.label);
        this.MULT = this.Terminal(Token.MULT.label);
        this.NE = this.Terminal(Token.NE.label);
        this.NOT = this.Terminal(Token.NOT.label);
        this.NOT_MATCH = this.Terminal(Token.NOT_MATCH.label);
        this.OR = this.Terminal(Token.OR.label);
        this.PLUS = this.Terminal(Token.PLUS.label);
        this.POWER = this.Terminal(Token.POWER.label);
        this.QUERY = this.Terminal("?");
        this.RPAR = this.Terminal(")");
    }

    public Rule Top() {
        return this.Sequence(this.If(), EOI, new Object[0]);
    }

    @SuppressWarnings(value={"IL_INFINITE_RECURSIVE_LOOP"})
    Rule If() {
        return this.Sequence(this.Disjunction(), this.Optional(this.QUERY, this.If(), new Object[]{this.COLON, this.If(), this.push((Object)new Expression(Token.IF, (Expression)((Object)this.pop(2)), (Expression)((Object)this.pop(1)), (Expression)((Object)this.pop())))}), new Object[0]);
    }

    Rule Disjunction() {
        return this.BinaryOperatorRule(this.Conjunction(), this.OR);
    }

    Rule Conjunction() {
        return this.BinaryOperatorRule(this.Negation(), this.AND);
    }

    Rule Negation() {
        return this.UnaryOperatorRule(this.Relational(), this.NOT);
    }

    Rule Relational() {
        return this.BinaryOperatorRule(this.Additive(), this.FirstOf(this.EQ, this.NE, new Object[]{this.LE, this.LT, this.GE, this.GT}));
    }

    Rule Additive() {
        return this.BinaryOperatorRule(this.Multiplicative(), this.FirstOf(this.PLUS, this.MINUS, new Object[0]));
    }

    Rule Multiplicative() {
        return this.BinaryOperatorRule(this.Match(), this.FirstOf(this.MULT, this.DIV, new Object[]{this.MOD}));
    }

    Rule Match() {
        return this.BinaryOperatorRule(this.Unary(), this.FirstOf(this.MATCH, this.NOT_MATCH, new Object[0]));
    }

    Rule Unary() {
        Var neg = new Var();
        return this.Sequence(neg.set((Object)false), this.ZeroOrMore(this.FirstOf(this.PLUS, this.Sequence(this.MINUS, neg.set((Object)((Boolean)neg.get() == false ? 1 : 0)), new Object[0]), new Object[0])), new Object[]{this.Power(), (Boolean)neg.get() != false ? this.push((Object)new Expression(Token.UMINUS, (Expression)((Object)this.pop()))) : true});
    }

    Rule Power() {
        return this.BinaryOperatorRule(this.Primary(), this.POWER);
    }

    Rule Primary() {
        return this.FirstOf(this.Sequence(this.LPAR, this.If(), new Object[]{this.RPAR}), this.Literal(), new Object[]{this.QualifiedIdentifier()});
    }

    Rule Literal() {
        return this.Sequence(this.FirstOf(this.Sequence("true", this.TestNot(this.LetterOrDigit()), new Object[]{this.push((Object)new Expression(Token.TRUE, new Expression[0]))}), this.Sequence("false", this.TestNot(this.LetterOrDigit()), new Object[]{this.push((Object)new Expression(Token.FALSE, new Expression[0]))}), new Object[]{this.Number(), this.StringLiteral()}), this.Spacing(), new Object[0]);
    }

    Rule StringLiteral() {
        return this.FirstOf(this.Sequence(Character.valueOf('\"'), this.ZeroOrMore(this.Sequence(this.TestNot(this.AnyOf("\r\n\"\\")), ANY, new Object[0])).suppressSubnodes(), new Object[]{this.push((Object)new Expression(Token.STRING_LITERAL, this.match())), Character.valueOf('\"')}), this.Sequence(Character.valueOf('\''), this.ZeroOrMore(this.Sequence(this.TestNot(this.AnyOf("\r\n'\\")), ANY, new Object[0])).suppressSubnodes(), new Object[]{this.push((Object)new Expression(Token.STRING_LITERAL, this.match())), Character.valueOf('\'')}), new Object[0]);
    }

    Rule QualifiedIdentifier() {
        return this.Sequence(this.Sequence(this.Identifier(), this.ZeroOrMore(this.Ch('.'), this.Identifier(), new Object[0]), new Object[0]), this.push((Object)new Expression(Token.IDENTIFIER, this.match())), new Object[]{this.Spacing()});
    }

    Rule Identifier() {
        return this.Sequence(this.Letter(), this.ZeroOrMore(this.LetterOrDigit()), new Object[0]);
    }

    Rule Letter() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{Character.valueOf('_'), Character.valueOf('$')});
    }

    Rule LetterOrDigit() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{this.CharRange('0', '9'), Character.valueOf('_'), Character.valueOf('$')});
    }

    @Cached
    @SuppressWarnings(value={"IL_INFINITE_RECURSIVE_LOOP"})
    Rule UnaryOperatorRule(Rule subRule, Rule operatorRule) {
        Var op = new Var();
        return this.FirstOf(this.Sequence(operatorRule, op.set((Object)Token.find(this.match().trim())), new Object[]{this.UnaryOperatorRule(subRule, operatorRule), this.push((Object)new Expression((Token)((Object)op.get()), (Expression)((Object)this.pop())))}), subRule, new Object[0]);
    }

    Rule BinaryOperatorRule(Rule subRule, Rule operatorRule) {
        Var op = new Var();
        return this.Sequence(subRule, this.ZeroOrMore(operatorRule, op.set((Object)Token.find(this.match().trim())), new Object[]{subRule, this.push((Object)new Expression((Token)((Object)op.get()), (Expression)((Object)this.pop(1)), (Expression)((Object)this.pop())))}), new Object[0]);
    }

    Rule Number() {
        return this.Sequence(this.Sequence(this.OneOrMore(this.Digit()), this.Optional(this.Ch('.'), this.OneOrMore(this.Digit()), new Object[0]), new Object[0]), this.push((Object)new Expression(Double.parseDouble(this.match()))), new Object[]{this.Spacing(), this.Optional(this.Unit(), this.push((Object)new Expression(Token.MULT, (Expression)((Object)this.pop()), (Expression)((Object)this.pop()))), new Object[0])});
    }

    Rule Unit() {
        return this.FirstOf(this.UnitRule("Ki", 1024L), this.UnitRule("Mi", 0x100000L), new Object[]{this.UnitRule("Gi", 0x40000000L), this.UnitRule("Ti", 0x10000000000L), this.UnitRule("Pi", 0x4000000000000L), this.UnitRule("k", 1000L), this.UnitRule("K", 1000L), this.UnitRule("M", 1000000L), this.UnitRule("G", 1000000000L), this.UnitRule("T", 1000000000000L), this.UnitRule("P", 1000000000000000L)});
    }

    Rule UnitRule(String s, long factor) {
        return this.Sequence(s, this.push((Object)new Expression(factor)), new Object[0]);
    }

    Rule Digit() {
        return this.CharRange('0', '9');
    }

    @SuppressNode
    Rule Spacing() {
        return this.ZeroOrMore(this.AnyOf(" \t\r\n\f"));
    }

    @SuppressNode
    @DontLabel
    Rule Terminal(String string) {
        return this.Sequence(string, this.Spacing(), new Object[0]).label(string);
    }
}

