/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.expression;

import org.dcache.util.expression.Expression;
import org.dcache.util.expression.Symbol;
import org.dcache.util.expression.SymbolTable;

public class ExpressionEvaluator {
    private final SymbolTable _symbols;

    public ExpressionEvaluator(SymbolTable symbols) {
        this._symbols = symbols;
    }

    public Object evaluate(Expression expression) {
        switch (expression.getType()) {
            case DOUBLE: {
                return this.evaluateDouble(expression);
            }
            case BOOLEAN: {
                return this.evaluateBoolean(expression);
            }
            case STRING: {
                return this.evaluateString(expression);
            }
        }
        throw new IllegalArgumentException("Expression lacks type annotation");
    }

    public double evaluateDouble(Expression expression) {
        switch (expression.getToken()) {
            case NUMBER_LITERAL: {
                return expression.getNumber();
            }
            case IDENTIFIER: {
                String identifier = expression.getString();
                Symbol value = (Symbol)this._symbols.get(identifier);
                if (value == null) {
                    throw new IllegalArgumentException("Unknown identifier: " + identifier);
                }
                return (Double)value.getValue();
            }
            case PLUS: {
                return this.evaluateDouble(expression.get(0)) + this.evaluateDouble(expression.get(1));
            }
            case MINUS: {
                return this.evaluateDouble(expression.get(0)) - this.evaluateDouble(expression.get(1));
            }
            case MULT: {
                return this.evaluateDouble(expression.get(0)) * this.evaluateDouble(expression.get(1));
            }
            case DIV: {
                return this.evaluateDouble(expression.get(0)) / this.evaluateDouble(expression.get(1));
            }
            case MOD: {
                return this.evaluateDouble(expression.get(0)) % this.evaluateDouble(expression.get(1));
            }
            case POWER: {
                return Math.pow(this.evaluateDouble(expression.get(0)), this.evaluateDouble(expression.get(1)));
            }
            case IF: {
                return this.evaluateBoolean(expression.get(0)) ? this.evaluateDouble(expression.get(1)) : this.evaluateDouble(expression.get(2));
            }
            case UMINUS: {
                return -this.evaluateDouble(expression.get(0));
            }
        }
        throw new IllegalArgumentException("Invalid operator: " + (Object)((Object)expression.getToken()));
    }

    public boolean evaluateBoolean(Expression expression) {
        switch (expression.getToken()) {
            case IDENTIFIER: {
                String identifier = expression.getString();
                Symbol value = (Symbol)this._symbols.get(identifier);
                if (value == null) {
                    throw new IllegalArgumentException("Unknown identifier: " + identifier);
                }
                return (Boolean)value.getValue();
            }
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case LT: {
                return this.evaluateDouble(expression.get(0)) < this.evaluateDouble(expression.get(1));
            }
            case LE: {
                return this.evaluateDouble(expression.get(0)) <= this.evaluateDouble(expression.get(1));
            }
            case GT: {
                return this.evaluateDouble(expression.get(0)) > this.evaluateDouble(expression.get(1));
            }
            case GE: {
                return this.evaluateDouble(expression.get(0)) >= this.evaluateDouble(expression.get(1));
            }
            case EQ: {
                switch (expression.get(0).getType()) {
                    case DOUBLE: {
                        return this.evaluateDouble(expression.get(0)) == this.evaluateDouble(expression.get(1));
                    }
                    case BOOLEAN: {
                        return this.evaluateBoolean(expression.get(1)) == this.evaluateBoolean(expression.get(1));
                    }
                    case STRING: {
                        return this.evaluateString(expression.get(0)).equals(this.evaluateString(expression.get(1)));
                    }
                }
                throw new IllegalStateException("Expression lacks type annotation");
            }
            case NE: {
                switch (expression.get(0).getType()) {
                    case DOUBLE: {
                        return this.evaluateDouble(expression.get(0)) != this.evaluateDouble(expression.get(1));
                    }
                    case BOOLEAN: {
                        return this.evaluateBoolean(expression.get(0)) != this.evaluateBoolean(expression.get(1));
                    }
                    case STRING: {
                        return !this.evaluateString(expression.get(0)).equals(this.evaluateString(expression.get(1)));
                    }
                }
                throw new IllegalStateException("Expression lacks type annotation");
            }
            case IF: {
                return this.evaluateBoolean(expression.get(0)) ? this.evaluateBoolean(expression.get(1)) : this.evaluateBoolean(expression.get(2));
            }
            case AND: {
                return this.evaluateBoolean(expression.get(0)) && this.evaluateBoolean(expression.get(1));
            }
            case OR: {
                return this.evaluateBoolean(expression.get(0)) || this.evaluateBoolean(expression.get(1));
            }
            case NOT: {
                return !this.evaluateBoolean(expression.get(0));
            }
            case MATCH: {
                return this.evaluateString(expression.get(0)).matches(this.evaluateString(expression.get(1)));
            }
            case NOT_MATCH: {
                return !this.evaluateString(expression.get(0)).matches(this.evaluateString(expression.get(1)));
            }
        }
        throw new IllegalArgumentException("Invalid operator: " + (Object)((Object)expression.getToken()));
    }

    public String evaluateString(Expression expression) {
        switch (expression.getToken()) {
            case STRING_LITERAL: {
                return expression.getString();
            }
            case IDENTIFIER: {
                String identifier = expression.getString();
                Symbol value = (Symbol)this._symbols.get(identifier);
                if (value == null) {
                    throw new IllegalArgumentException("Unknown identifier: " + identifier);
                }
                return (String)value.getValue();
            }
            case IF: {
                return this.evaluateBoolean(expression.get(0)) ? this.evaluateString(expression.get(1)) : this.evaluateString(expression.get(2));
            }
        }
        throw new IllegalArgumentException("Invalid operator: " + (Object)((Object)expression.getToken()));
    }
}

