/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.nio.channels.CompletionHandler;
import org.dcache.pool.classic.Cancellable;

public abstract class TryCatchTemplate<V, A>
implements Cancellable,
CompletionHandler<V, A> {
    private final Closer _closer = Closer.create();
    private final CompletionHandler<V, A> _completionHandler;
    private volatile Cancellable _cancellable;

    public TryCatchTemplate(CompletionHandler<V, A> completionHandler) {
        this._completionHandler = completionHandler;
        try {
            this.execute();
        }
        catch (Throwable t) {
            this.failed(t, null);
        }
    }

    @Override
    public void cancel() {
        if (this._cancellable != null) {
            this._cancellable.cancel();
        }
    }

    @Override
    public final void completed(V result, A attachment) {
        try {
            this._closer.close();
            this.onSuccess(result, attachment);
            this._completionHandler.completed(result, attachment);
        }
        catch (Throwable t) {
            this.fail(t, attachment);
        }
    }

    @Override
    public final void failed(Throwable exc, A attachment) {
        try {
            try {
                throw this._closer.rethrow(exc, Exception.class);
            }
            catch (Throwable throwable) {
                this._closer.close();
                throw throwable;
            }
        }
        catch (Throwable t) {
            this.fail(t, attachment);
            return;
        }
    }

    private void fail(Throwable t, A attachment) {
        try {
            this.onFailure(t, attachment);
        }
        catch (Exception replacement) {
            if (replacement.getCause() == t) {
                t = replacement;
            } else if (replacement != t) {
                t.addSuppressed(replacement);
            }
        }
        catch (Throwable suppressed) {
            t.addSuppressed(t);
        }
        this._completionHandler.failed(t, attachment);
    }

    protected <C extends Closeable> C autoclose(C closeable) {
        return (C)this._closer.register(closeable);
    }

    protected void setCancellable(Cancellable cancellable) {
        Preconditions.checkState((this._cancellable == null ? 1 : 0) != 0);
        this._cancellable = (Cancellable)Preconditions.checkNotNull((Object)cancellable);
    }

    protected void execute() throws Exception {
        this.setCancellable(this.executeWithCancellable());
    }

    protected Cancellable executeWithCancellable() throws Exception {
        return null;
    }

    protected void onSuccess(V result, A attachment) throws Exception {
    }

    protected void onFailure(Throwable t, A attachment) throws Exception {
    }
}

