/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import diskCacheV111.poolManager.RequestContainerV5;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CheckStagePermission;
import diskCacheV111.util.FileExistsCacheException;
import diskCacheV111.util.FileIsNewCacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.NotFileCacheException;
import diskCacheV111.util.NotInTrashCacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.DoorRequestInfoMessage;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.IoDoorEntry;
import diskCacheV111.vehicles.IoJobInfo;
import diskCacheV111.vehicles.PnfsCreateEntryMessage;
import diskCacheV111.vehicles.PoolAcceptFileMessage;
import diskCacheV111.vehicles.PoolDeliverFileMessage;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.PoolMgrSelectReadPoolMsg;
import diskCacheV111.vehicles.PoolMgrSelectWritePoolMsg;
import diskCacheV111.vehicles.PoolMoverKillMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.TimebasedCounter;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.acl.enums.AccessMask;
import org.dcache.cells.CellStub;
import org.dcache.commons.util.NDC;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.util.CacheExceptionFactory;
import org.dcache.util.MathUtils;
import org.dcache.util.TransferRetryPolicy;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Transfer
implements Comparable<Transfer> {
    private static final Logger _log = LoggerFactory.getLogger(Transfer.class);
    private static final TimebasedCounter _sessionCounter = new TimebasedCounter();
    protected final PnfsHandler _pnfs;
    protected final long _startedAt;
    protected final FsPath _path;
    protected final Subject _subject;
    protected final long _sessionId;
    protected final Object _session;
    protected CellStub _poolManager;
    protected CellStub _pool;
    protected CellStub _billing;
    protected CheckStagePermission _checkStagePermission;
    private String _cellName;
    private String _domainName;
    private String _poolName;
    private CellAddressCore _poolAddress;
    private Integer _moverId;
    private boolean _hasMoverBeenCreated;
    private boolean _hasMoverFinished;
    private String _status;
    private CacheException _error;
    private FileAttributes _fileAttributes = new FileAttributes();
    private ProtocolInfo _protocolInfo;
    private boolean _isWrite;
    private InetSocketAddress _clientAddress;
    private long _allocated;
    private PoolMgrSelectReadPoolMsg.Context _readPoolSelectionContext;
    private boolean _isBillingNotified;
    private boolean _isOverwriteAllowed;
    private Set<FileAttribute> _additionalAttributes = EnumSet.noneOf(FileAttribute.class);

    public Transfer(PnfsHandler pnfs, Subject subject, FsPath path) {
        this._pnfs = new PnfsHandler(pnfs, subject);
        this._subject = subject;
        this._path = path;
        this._startedAt = System.currentTimeMillis();
        this._sessionId = _sessionCounter.next();
        this._session = CDC.getSession();
        this._checkStagePermission = new CheckStagePermission(null);
    }

    protected ProtocolInfo getProtocolInfoForPoolManager() {
        Preconditions.checkNotNull((Object)this._protocolInfo);
        return this._protocolInfo;
    }

    protected ProtocolInfo getProtocolInfoForPool() {
        Preconditions.checkNotNull((Object)this._protocolInfo);
        return this._protocolInfo;
    }

    public synchronized void setProtocolInfo(ProtocolInfo info) {
        this._protocolInfo = info;
    }

    public synchronized ProtocolInfo getProtocolInfo() {
        return this._protocolInfo;
    }

    @Override
    public int compareTo(Transfer o) {
        return Longs.compare((long)o.getSessionId(), (long)this.getSessionId());
    }

    public long getSessionId() {
        return this._sessionId;
    }

    public synchronized void setPoolManagerStub(CellStub stub) {
        this._poolManager = stub;
    }

    public synchronized void setPoolStub(CellStub stub) {
        this._pool = stub;
    }

    public synchronized void setBillingStub(CellStub stub) {
        this._billing = stub;
    }

    public synchronized void setCheckStagePermission(CheckStagePermission checkStagePermission) {
        this._checkStagePermission = checkStagePermission;
    }

    public synchronized void setStatus(String status) {
        if (status != null) {
            _log.debug("Status: {}", (Object)status);
        }
        this._status = status;
    }

    public synchronized String getStatus() {
        return this._status;
    }

    public synchronized void setOverwriteAllowed(boolean allowed) {
        this._isOverwriteAllowed = allowed;
    }

    public synchronized FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    public synchronized void setFileAttributes(FileAttributes fileAttributes) {
        this._fileAttributes = fileAttributes;
    }

    public synchronized PnfsId getPnfsId() {
        return this._fileAttributes.isDefined(FileAttribute.PNFSID) ? this._fileAttributes.getPnfsId() : null;
    }

    public synchronized void setPnfsId(PnfsId pnfsid) {
        this._fileAttributes.setPnfsId(pnfsid);
    }

    public synchronized StorageInfo getStorageInfo() {
        return this._fileAttributes.getStorageInfo();
    }

    public synchronized void setStorageInfo(StorageInfo info) {
        this._fileAttributes.setStorageInfo(info);
    }

    public synchronized void setWrite(boolean isWrite) {
        this._isWrite = isWrite;
    }

    public synchronized boolean isWrite() {
        return this._isWrite;
    }

    public synchronized void setMoverId(Integer moverId) {
        this._moverId = moverId;
        this._hasMoverBeenCreated = this._moverId != null;
    }

    public synchronized Integer getMoverId() {
        return this._moverId;
    }

    public synchronized boolean hasMover() {
        return this._hasMoverBeenCreated && !this._hasMoverFinished;
    }

    public synchronized void setPool(String pool) {
        this._poolName = pool;
    }

    public synchronized String getPool() {
        return this._poolName;
    }

    public synchronized void setPoolAddress(CellAddressCore poolAddress) {
        this._poolAddress = poolAddress;
    }

    public synchronized CellAddressCore getPoolAddress() {
        return this._poolAddress;
    }

    public static void initSession() {
        String domainName = MDC.get((String)"cells.domain");
        if (domainName == null) {
            throw new IllegalStateException("Missing domain name in MDC");
        }
        String cellName = MDC.get((String)"cells.cell");
        if (cellName == null) {
            throw new IllegalStateException("Missing cell name in MDC");
        }
        CDC.createSession((String)("door:" + cellName + "@" + domainName + ":"));
        NDC.push((String)CDC.getSession());
    }

    public synchronized String getTransaction() {
        if (this._session != null) {
            return this._session.toString() + "-" + this._sessionId;
        }
        if (this._cellName != null && this._domainName != null) {
            return "door:" + this._cellName + "@" + this._domainName + "-" + this._sessionId;
        }
        return String.valueOf(this._sessionId);
    }

    public synchronized void finished(CacheException error) {
        this._hasMoverFinished = true;
        this._error = error;
        this.notifyAll();
    }

    public final synchronized void finished(int rc, String error) {
        if (rc != 0) {
            this.finished(new CacheException(rc, error));
        } else {
            this.finished((CacheException)null);
        }
    }

    public final synchronized void finished(DoorTransferFinishedMessage msg) {
        this.setFileAttributes(msg.getFileAttributes());
        this.setProtocolInfo(msg.getProtocolInfo());
        if (msg.getReturnCode() != 0) {
            this.finished(CacheExceptionFactory.exceptionOf(msg));
        } else {
            this.finished((CacheException)null);
        }
    }

    public synchronized void setCellName(String cellName) {
        this._cellName = cellName;
    }

    public synchronized String getCellName() {
        return this._cellName;
    }

    public synchronized void setDomainName(String domainName) {
        this._domainName = domainName;
    }

    public synchronized String getDomainName() {
        return this._domainName;
    }

    public synchronized void setClientAddress(InetSocketAddress address) {
        this._clientAddress = address;
    }

    public synchronized InetSocketAddress getClientAddress() {
        return this._clientAddress;
    }

    public synchronized boolean waitForMover(long millis) throws CacheException, InterruptedException {
        long deadline = System.currentTimeMillis() + millis;
        while (!this._hasMoverFinished && System.currentTimeMillis() < deadline) {
            this.wait(deadline - System.currentTimeMillis());
        }
        if (this._error != null) {
            throw this._error;
        }
        return this._hasMoverFinished;
    }

    public synchronized IoDoorEntry getIoDoorEntry() {
        return new IoDoorEntry(this._sessionId, this.getPnfsId(), this._poolName, this._status, this._startedAt, this._clientAddress.getHostString());
    }

    public void createNameSpaceEntryWithParents() throws CacheException {
        try {
            this.createNameSpaceEntry();
        }
        catch (FileNotFoundCacheException | NotInTrashCacheException e) {
            this._pnfs.createDirectories(this._path.getParent());
            this.createNameSpaceEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNameSpaceEntry() throws CacheException {
        this.setStatus("PnfsManager: Creating name space entry");
        try {
            PnfsCreateEntryMessage msg;
            try {
                msg = this._pnfs.createPnfsEntry(this._path.toString());
            }
            catch (FileExistsCacheException e) {
                if (!this._isOverwriteAllowed) {
                    throw e;
                }
                this._pnfs.deletePnfsEntry(this._path.toString(), EnumSet.of(FileType.REGULAR));
                msg = this._pnfs.createPnfsEntry(this._path.toString());
            }
            this.setFileAttributes(msg.getFileAttributes());
            this.setWrite(true);
        }
        finally {
            this.setStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNameSpaceEntry() throws CacheException {
        this.setStatus("PnfsManager: Fetching storage info");
        try {
            EnumSet<FileAttribute> request = EnumSet.of(FileAttribute.PNFSID, FileAttribute.TYPE, FileAttribute.STORAGEINFO, FileAttribute.SIZE);
            request.addAll(this._additionalAttributes);
            request.addAll(PoolMgrSelectReadPoolMsg.getRequiredAttributes());
            EnumSet<AccessMask> mask = EnumSet.of(AccessMask.READ_DATA);
            PnfsId pnfsId = this.getPnfsId();
            FileAttributes attributes = pnfsId != null ? this._pnfs.getFileAttributes(pnfsId, request, mask) : this._pnfs.getFileAttributes(this._path.toString(), request, mask);
            FileType type = attributes.getFileType();
            if (type == FileType.DIR || type == FileType.SPECIAL) {
                throw new NotFileCacheException("Not a regular file");
            }
            this.setFileAttributes(attributes);
            this.setWrite(false);
        }
        finally {
            this.setStatus(null);
        }
    }

    protected void setAdditionalAttributes(Set<FileAttribute> attributes) {
        this._additionalAttributes = Sets.immutableEnumSet(attributes);
    }

    protected Set<FileAttribute> getAdditionalAttributes() {
        return this._additionalAttributes;
    }

    public synchronized long getLength() {
        return this._fileAttributes.getSize();
    }

    public synchronized void setLength(long length) {
        if (!this.isWrite()) {
            throw new IllegalStateException("Can only set length for uploads");
        }
        this._fileAttributes.setSize(length);
    }

    public synchronized void setAllocation(long length) {
        this._allocated = length;
    }

    protected synchronized PoolMgrSelectReadPoolMsg.Context getReadPoolSelectionContext() {
        return this._readPoolSelectionContext;
    }

    protected synchronized void setReadPoolSelectionContext(PoolMgrSelectReadPoolMsg.Context context) {
        this._readPoolSelectionContext = context;
    }

    public void selectPool() throws CacheException, InterruptedException {
        this.selectPool(this._poolManager.getTimeout());
    }

    private void selectPool(long timeout) throws CacheException, InterruptedException {
        block8: {
            FileAttributes fileAttributes = this.getFileAttributes();
            this.setStatus("PoolManager: Selecting pool");
            try {
                ProtocolInfo protocolInfo = this.getProtocolInfoForPoolManager();
                if (this.isWrite()) {
                    long allocated = this._allocated;
                    if (allocated == 0L) {
                        allocated = fileAttributes.getSize();
                    }
                    PoolMgrSelectWritePoolMsg request = new PoolMgrSelectWritePoolMsg(fileAttributes, protocolInfo, allocated);
                    request.setId(this._sessionId);
                    request.setSubject(this._subject);
                    request.setPnfsPath(this._path.toString());
                    PoolMgrSelectWritePoolMsg reply = this._poolManager.sendAndWait(request, timeout);
                    this.setPool(reply.getPoolName());
                    this.setPoolAddress(reply.getPoolAddress());
                    this.setStorageInfo(reply.getStorageInfo());
                    break block8;
                }
                if (!this._fileAttributes.getStorageInfo().isCreatedOnly()) {
                    EnumSet<RequestContainerV5.RequestState> allowedStates = this._checkStagePermission.canPerformStaging(this._subject, fileAttributes.getStorageInfo()) ? RequestContainerV5.allStates : RequestContainerV5.allStatesExceptStage;
                    PoolMgrSelectReadPoolMsg request = new PoolMgrSelectReadPoolMsg(fileAttributes, protocolInfo, this.getReadPoolSelectionContext(), allowedStates);
                    request.setId(this._sessionId);
                    request.setSubject(this._subject);
                    request.setPnfsPath(this._path.toString());
                    PoolMgrSelectReadPoolMsg reply = this._poolManager.sendAndWait(request, timeout);
                    this.setPool(reply.getPoolName());
                    this.setPoolAddress(reply.getPoolAddress());
                    this.setStorageInfo(reply.getStorageInfo());
                    this.setReadPoolSelectionContext(reply.getContext());
                    break block8;
                }
                throw new FileIsNewCacheException();
            }
            catch (IOException e) {
                throw new CacheException(10011, e.getMessage());
            }
            finally {
                this.setStatus(null);
            }
        }
    }

    public void startMover(String queue) throws CacheException, InterruptedException {
        this.startMover(queue, this._pool.getTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMover(String queue, long timeout) throws CacheException, InterruptedException {
        FileAttributes fileAttributes = this.getFileAttributes();
        String pool = this.getPool();
        if (fileAttributes == null || pool == null) {
            throw new IllegalStateException("Need PNFS ID, file attributes and pool before a mover can be started");
        }
        this.setStatus("Pool " + pool + ": Creating mover");
        try {
            ProtocolInfo protocolInfo = this.getProtocolInfoForPool();
            PoolIoFileMessage message = this.isWrite() ? new PoolAcceptFileMessage(pool, protocolInfo, fileAttributes) : new PoolDeliverFileMessage(pool, protocolInfo, fileAttributes);
            message.setIoQueueName(queue);
            message.setInitiator(this.getTransaction());
            message.setId(this._sessionId);
            message.setSubject(this._subject);
            CellPath poolPath = (CellPath)this._poolManager.getDestinationPath().clone();
            poolPath.add(this.getPoolAddress());
            this.setMoverId(this._pool.sendAndWait(poolPath, message, timeout).getMoverId());
        }
        finally {
            this.setStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killMover(long millis) {
        if (!this.hasMover()) {
            return;
        }
        Integer moverId = this.getMoverId();
        String pool = this.getPool();
        CellAddressCore poolAddress = this.getPoolAddress();
        this.setStatus("Mover " + pool + "/" + moverId + ": Killing mover");
        try {
            PoolMoverKillMessage message = new PoolMoverKillMessage(pool, moverId);
            message.setReplyRequired(false);
            this._pool.send(new CellPath(poolAddress), message);
            if (millis > 0L && !this.waitForMover(millis)) {
                _log.error("Failed to kill mover " + pool + "/" + moverId + ": Timeout");
            }
        }
        catch (CacheException e) {
            _log.debug("Killed mover and pool reported: " + e.getMessage());
        }
        catch (InterruptedException e) {
            _log.warn("Failed to kill mover " + pool + "/" + moverId + ": " + e.getMessage());
            Thread.currentThread().interrupt();
        }
        catch (NoRouteToCellException e) {
            _log.error("Failed to kill mover " + pool + "/" + moverId + ": " + e.getMessage());
        }
        finally {
            this.setStatus(null);
        }
    }

    public IoJobInfo queryMoverInfo() throws CacheException, InterruptedException {
        if (!this.hasMover()) {
            throw new IllegalStateException("Transfer has no mover");
        }
        return this._pool.sendAndWait(new CellPath(this.getPoolAddress()), (Serializable)((Object)("mover ls -binary " + this.getMoverId())), IoJobInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNameSpaceEntry() {
        if (!this.isWrite()) {
            throw new IllegalStateException("Can only delete name space entry for uploads");
        }
        PnfsId pnfsId = this.getPnfsId();
        if (pnfsId != null) {
            this.setStatus("PnfsManager: Deleting name space entry");
            try {
                this._pnfs.deletePnfsEntry(pnfsId, this._path.toString());
            }
            catch (CacheException e) {
                _log.error("Failed to delete file after failed upload: " + this._path + " (" + pnfsId + "): " + e.getMessage());
            }
            finally {
                this.setStatus(null);
            }
        }
    }

    public synchronized void notifyBilling(int code, String error) {
        if (this._isBillingNotified) {
            return;
        }
        try {
            DoorRequestInfoMessage msg = new DoorRequestInfoMessage(this.getCellName() + "@" + this.getDomainName());
            msg.setSubject(this._subject);
            msg.setPath(this._path.toString());
            msg.setTransactionDuration(System.currentTimeMillis() - this._startedAt);
            msg.setTransaction(this.getTransaction());
            msg.setClient(this._clientAddress.getAddress().getHostAddress());
            msg.setPnfsId(this.getPnfsId());
            msg.setResult(code, error);
            if (this._fileAttributes.isDefined(FileAttribute.STORAGEINFO)) {
                msg.setStorageInfo(this._fileAttributes.getStorageInfo());
            }
            this._billing.send(msg);
            this._isBillingNotified = true;
        }
        catch (NoRouteToCellException e) {
            _log.error("Failed to register transfer in billing: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPoolAndStartMover(String queue, TransferRetryPolicy policy) throws CacheException, InterruptedException {
        long deadLine = MathUtils.addWithInfinity(System.currentTimeMillis(), policy.getTotalTimeOut());
        long retryCount = policy.getRetryCount();
        long retryPeriod = policy.getRetryPeriod();
        block10: while (true) {
            CacheException lastFailure;
            boolean gotPool = false;
            long start = System.currentTimeMillis();
            try {
                this.selectPool(MathUtils.subWithInfinity(deadLine, System.currentTimeMillis()));
                gotPool = true;
                this.startMover(queue, Math.min(MathUtils.subWithInfinity(deadLine, System.currentTimeMillis()), policy.getMoverStartTimeout()));
                return;
            }
            catch (TimeoutCacheException e) {
                _log.warn(e.getMessage());
                if (gotPool && this.isWrite()) {
                    throw e;
                }
                lastFailure = e;
            }
            catch (CacheException e) {
                switch (e.getRc()) {
                    case 104: 
                    case 10007: 
                    case 10021: {
                        _log.info("Retrying pool selection: {}", (Object)e.getMessage());
                        if (this.isWrite()) continue block10;
                        this.readNameSpaceEntry();
                        continue block10;
                    }
                    case 210: {
                        throw e;
                    }
                }
                _log.error(e.toString());
                lastFailure = e;
            }
            long now = System.currentTimeMillis();
            long timeToSleep = Math.max(0L, retryPeriod - (now - start));
            if (--retryCount == 0L || MathUtils.subWithInfinity(deadLine, now) <= timeToSleep) {
                throw lastFailure;
            }
            this.setStatus("Sleeping (" + lastFailure.getMessage() + ")");
            try {
                Thread.sleep(timeToSleep);
            }
            finally {
                this.setStatus(null);
            }
            if (this.isWrite()) continue;
            this.readNameSpaceEntry();
        }
    }
}

