/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import liquibase.Liquibase;
import liquibase.changelog.ChangeSet;
import liquibase.exception.LiquibaseException;
import liquibase.exception.MigrationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class SpringLiquibase
extends liquibase.integration.spring.SpringLiquibase {
    private static final Logger _log = LoggerFactory.getLogger(SpringLiquibase.class);
    private boolean _shouldUpdate = true;

    public void setShouldUpdate(boolean shouldUpdate) {
        this._shouldUpdate = shouldUpdate;
    }

    public boolean getShouldUpdate() {
        return this._shouldUpdate;
    }

    public void afterPropertiesSet() {
        this.getJdbcTemplate().execute((ConnectionCallback)new SchemaMigrator());
    }

    protected JdbcTemplate getJdbcTemplate() {
        return new JdbcTemplate(this.getDataSource());
    }

    private class SchemaMigrator
    implements ConnectionCallback<Void> {
        private SchemaMigrator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void doInConnection(Connection c) throws SQLException, DataAccessException {
            try {
                Liquibase liquibase = SpringLiquibase.this.createLiquibase(c);
                try {
                    if (SpringLiquibase.this._shouldUpdate) {
                        liquibase.update(SpringLiquibase.this.getContexts());
                    } else {
                        List changeSets = liquibase.listUnrunChangeSets(SpringLiquibase.this.getContexts());
                        if (!changeSets.isEmpty()) {
                            throw new MigrationFailedException((ChangeSet)changeSets.get(0), "Automatic schema migration is disabled. Please apply missing changes.");
                        }
                    }
                }
                finally {
                    liquibase.forceReleaseLocks();
                }
            }
            catch (LiquibaseException e) {
                throw new SQLException("Schema migration failed", e);
            }
            return null;
        }
    }
}

