/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.dcache.util.ConfigurationProperties;

public class ScopedConfigurationProperties
extends ConfigurationProperties {
    private static final long serialVersionUID = -2860424171428548614L;
    private final String _scope;

    public ScopedConfigurationProperties(Properties properties, String scope) {
        super(properties);
        this._scope = scope;
    }

    public static boolean isScoped(String name) {
        return name.indexOf(47) > -1;
    }

    public static boolean isScoped(String scope, String name) {
        return scope.length() < name.length() && name.startsWith(scope) && name.charAt(scope.length()) == '/';
    }

    public static String stripScope(String name) {
        int pos = name.indexOf(47);
        return pos == -1 ? name : name.substring(pos + 1);
    }

    @Override
    public Set<String> stringPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        for (String name : super.stringPropertyNames()) {
            if (!ScopedConfigurationProperties.isScoped(name)) {
                names.add(name);
                continue;
            }
            if (!ScopedConfigurationProperties.isScoped(this._scope, name)) continue;
            names.add(ScopedConfigurationProperties.stripScope(name));
        }
        return names;
    }

    @Override
    public String getProperty(String key) {
        String value = (String)this.get(key);
        if (value != null) {
            return value;
        }
        value = super.getProperty(this._scope + "/" + key);
        if (value != null) {
            return value;
        }
        return super.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public Object put(Object rawKey, Object value) {
        ConfigurationProperties.AnnotatedKey key = new ConfigurationProperties.AnnotatedKey(rawKey, value);
        if (!ScopedConfigurationProperties.isScoped(key.getPropertyName())) {
            ConfigurationProperties.AnnotatedKey scopedKey = new ConfigurationProperties.AnnotatedKey(this._scope + "/" + key.getPropertyName(), value);
            this.checkIsAllowed(scopedKey, (String)value);
        }
        return super.put(rawKey, value);
    }

    public String getScope() {
        return this._scope;
    }
}

