/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import diskCacheV111.util.PnfsId;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger _log = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Map<String, Method> methodCache = new HashMap<String, Method>();

    public static Method resolve(Class<?> c, String name, Class<?> ... parameters) {
        try {
            Object[] signature = new Object[]{c, name, parameters};
            String key = Arrays.deepToString(signature);
            Method m = methodCache.get(key);
            if (m != null) {
                return m;
            }
            m = c.getMethod(name, parameters);
            methodCache.put(key, m);
            return m;
        }
        catch (NoSuchMethodException e) {
            for (int i = 0; i < parameters.length; ++i) {
                Class<?> s = parameters[i].getSuperclass();
                if (s == null) continue;
                Class<?> old = parameters[i];
                parameters[i] = s;
                Method m = ReflectionUtils.resolve(c, name, parameters);
                if (m != null) {
                    return m;
                }
                parameters[i] = old;
            }
            return null;
        }
    }

    public static PnfsId getPnfsId(Object o) {
        try {
            Class<?> c = o.getClass();
            Method m = c.getMethod("getPnfsId", new Class[0]);
            if (PnfsId.class.isAssignableFrom(m.getReturnType()) && Modifier.isPublic(m.getModifiers())) {
                m.setAccessible(true);
                return (PnfsId)m.invoke(o, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
            _log.debug("Failed to extract PNFS ID from object: " + e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            _log.error("Failed to extract PNFS ID from message: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

