/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.TimeoutCacheException;
import javax.security.auth.Subject;
import org.dcache.util.Transfer;

public class RedirectedTransfer<T>
extends Transfer {
    private boolean _isRedirected;
    private T _redirectObject;

    public RedirectedTransfer(PnfsHandler pnfs, Subject subject, FsPath path) {
        super(pnfs, subject, path);
    }

    public synchronized void redirect(T object) {
        this._isRedirected = true;
        this._redirectObject = object;
        this.notifyAll();
    }

    public synchronized T getRedirect() {
        return this._redirectObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T waitForRedirect(long millis) throws CacheException, InterruptedException {
        try {
            this.setStatus("Mover " + this.getPool() + "/" + this.getMoverId() + ": Waiting for redirect");
            long deadline = System.currentTimeMillis() + millis;
            while (this.hasMover() && !this._isRedirected && System.currentTimeMillis() < deadline) {
                this.wait(deadline - System.currentTimeMillis());
            }
            if (this.waitForMover(0L)) {
                throw new CacheException("Mover finished without redirect");
            }
            if (!this._isRedirected) {
                throw new TimeoutCacheException("No redirect from mover");
            }
        }
        finally {
            this.setStatus(null);
        }
        return this._redirectObject;
    }
}

