/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import diskCacheV111.util.FsPath;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PrefixMap<V> {
    private final Map<FsPath, V> _entries = new ConcurrentHashMap<FsPath, V>();

    public int size() {
        return this._entries.size();
    }

    public Set<Map.Entry<FsPath, V>> entrySet() {
        return Collections.unmodifiableSet(this._entries.entrySet());
    }

    public void put(FsPath prefix, V value) {
        if (prefix == null || value == null) {
            throw new IllegalArgumentException("Null argument not allowed");
        }
        this._entries.put(prefix, value);
    }

    public V get(FsPath path) {
        if (path == null) {
            throw new IllegalArgumentException("Null argument not allowed");
        }
        path = new FsPath(path);
        V v = this._entries.get(path);
        while (v == null && !path.isEmpty()) {
            path.pop();
            v = this._entries.get(path);
        }
        return v;
    }
}

