/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;

public class PortRange {
    private static final Pattern FORMAT = Pattern.compile("(\\d+)(?:(?:,|:)(\\d+))?");
    private static final Random _random = new Random();
    private final int _lower;
    private final int _upper;

    public PortRange(int low, int high) {
        this._lower = low == 0 && high > 0 ? 1 : low;
        this._upper = high;
        if (low < 0 || high < low || 65535 < high) {
            throw new IllegalArgumentException("Invalid range");
        }
    }

    public PortRange(int port) {
        this(port, port);
    }

    public static PortRange valueOf(String s) throws IllegalArgumentException {
        try {
            Matcher m = FORMAT.matcher(s);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid range: " + s);
            }
            int low = Integer.parseInt(m.group(1));
            int high = m.groupCount() == 1 ? low : Integer.parseInt(m.group(2));
            return new PortRange(low, high);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid range: " + s);
        }
    }

    public int getLower() {
        return this._lower;
    }

    public int getUpper() {
        return this._upper;
    }

    public int random() {
        return _random.nextInt(this._upper - this._lower + 1) + this._lower;
    }

    public int succ(int port) {
        return port < this._upper ? port + 1 : this._lower;
    }

    public int bind(ServerSocket socket, InetSocketAddress endpoint) throws IOException {
        int port = endpoint.getPort();
        PortRange range = port > 0 ? new PortRange(port) : this;
        return range.bind(socket, endpoint.getAddress());
    }

    public int bind(Socket socket, InetSocketAddress endpoint) throws IOException {
        int port = endpoint.getPort();
        PortRange range = port > 0 ? new PortRange(port) : this;
        return range.bind(socket, endpoint.getAddress());
    }

    public int bind(ServerSocket socket, InetAddress address) throws IOException {
        int start;
        int port = start = this.random();
        while (true) {
            try {
                socket.bind(new InetSocketAddress(address, port));
                return port;
            }
            catch (BindException e) {
                if ((port = this.succ(port)) != start) continue;
                throw new BindException("No free port within range");
            }
            break;
        }
    }

    public int bind(Socket socket, InetAddress address) throws IOException {
        int start;
        int port = start = this.random();
        while (true) {
            try {
                socket.bind(new InetSocketAddress(address, port));
                return port;
            }
            catch (BindException e) {
                if ((port = this.succ(port)) != start) continue;
                throw new BindException("No free port within range");
            }
            break;
        }
    }

    public Channel bind(ServerBootstrap server, InetAddress address) throws IOException {
        int start;
        int port = start = this.random();
        while (true) {
            try {
                return server.bind((SocketAddress)new InetSocketAddress(address, port));
            }
            catch (ChannelException e) {
                if (e.getCause() instanceof BindException) continue;
                throw e;
                if ((port = this.succ(port)) != start) continue;
                throw new BindException("No free port within range");
            }
            break;
        }
    }

    public int bind(ServerSocket socket) throws IOException {
        return this.bind(socket, (InetAddress)null);
    }

    public int bind(Socket socket) throws IOException {
        return this.bind(socket, (InetAddress)null);
    }

    public Channel bind(ServerBootstrap socket) throws IOException {
        return this.bind(socket, null);
    }

    public String toString() {
        return String.format("%d:%d", this._lower, this._upper);
    }
}

