/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import diskCacheV111.util.CacheException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.dcache.util.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingMoversTask<T extends Transfer>
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(PingMoversTask.class);
    private final Collection<T> _transfers;
    private Set<Transfer> _missing = new HashSet<Transfer>();

    public PingMoversTask(Collection<T> transfers) {
        this._transfers = transfers;
    }

    @Override
    public void run() {
        try {
            Set<Transfer> missingLastTime = this._missing;
            this._missing = new HashSet<Transfer>();
            for (Transfer transfer : this._transfers) {
                try {
                    if (!transfer.hasMover()) continue;
                    transfer.queryMoverInfo();
                    _log.debug("Mover {}/{} is alive", (Object)transfer.getPool(), (Object)transfer.getMoverId());
                }
                catch (IllegalStateException e) {
                    _log.debug(e.toString());
                }
                catch (CacheException e) {
                    _log.info("Failed to check status of mover {}/{}: {}", new Object[]{transfer.getPool(), transfer.getMoverId(), e.getMessage()});
                    if (missingLastTime.contains(transfer)) {
                        transfer.finished(10006, String.format("Transfer killed by door due to failure for mover %s/%d: %s", transfer.getPool(), transfer.getMoverId(), e.getMessage()));
                        continue;
                    }
                    this._missing.add(transfer);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

