/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.LoginBrokerInfo;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginBrokerHandler
extends AbstractCellComponent
implements CellCommandListener {
    private static final Logger _log = LoggerFactory.getLogger(LoginBrokerHandler.class);
    private static final long EAGER_UPDATE_TIME = 1L;
    private CellPath _loginBroker;
    private String _protocolFamily;
    private String _protocolVersion;
    private String _protocolEngine;
    private long _brokerUpdateTime = 300L;
    private long _currentBrokerUpdateTime = 1L;
    private double _brokerUpdateThreshold = 0.1;
    private LoadProvider _load = new FixedLoad(0.0);
    private String[] _hosts;
    private int _port;
    private ScheduledExecutorService _executor;
    private ScheduledFuture<?> _task;
    public static final String hh_lb_set_update = "<updateTime/sec>";
    public static final String hh_lb_set_threshold = "<threshold>";

    public LoginBrokerHandler() {
        try {
            this.setAddresses(NetworkUtils.getLocalAddressesV4());
        }
        catch (SocketException e) {
            _log.error("Failed to obtain the IP addresses of this host: " + e.getMessage());
        }
    }

    public synchronized String ac_lb_set_update_$_1(Args args) {
        this.setUpdateTime(Long.parseLong(args.argv(0)));
        return "";
    }

    public synchronized String ac_lb_set_threshold_$_1(Args args) {
        this.setUpdateThreshold(Double.parseDouble(args.argv(0)));
        return "";
    }

    private synchronized void sendUpdate() {
        if (this._loginBroker == null || this._hosts == null) {
            return;
        }
        LoginBrokerInfo info = new LoginBrokerInfo(this.getCellName(), this.getCellDomainName(), this._protocolFamily, this._protocolVersion, this._protocolEngine);
        info.setUpdateTime(this._brokerUpdateTime * 1000L);
        info.setHosts(this._hosts);
        info.setPort(this._port);
        info.setLoad(this._load.getLoad());
        try {
            this.sendMessage(new CellMessage(this._loginBroker, (Serializable)info));
            this.normalUpdates();
        }
        catch (NoRouteToCellException e) {
            _log.error("Failed to send update to " + this._loginBroker);
            this.eagerUpdates();
        }
    }

    private void eagerUpdates() {
        if (this._currentBrokerUpdateTime != 1L) {
            this._currentBrokerUpdateTime = 1L;
            this.rescheduleTask();
        }
    }

    private void normalUpdates() {
        if (this._currentBrokerUpdateTime != this._brokerUpdateTime) {
            this._currentBrokerUpdateTime = this._brokerUpdateTime;
            this.rescheduleTask();
        }
    }

    @Override
    public synchronized void getInfo(PrintWriter pw) {
        if (this._loginBroker == null) {
            pw.println("    Login Broker : DISABLED");
            return;
        }
        pw.println("    LoginBroker      : " + this._loginBroker);
        pw.println("    Protocol Family  : " + this._protocolFamily);
        pw.println("    Protocol Version : " + this._protocolVersion);
        pw.println("    Update Time      : " + this._brokerUpdateTime + " seconds");
        pw.println("    Update Threshold : " + (int)(this._brokerUpdateThreshold * 100.0) + " %");
    }

    public synchronized void setAddresses(List<InetAddress> addresses) {
        this._hosts = new String[addresses.size()];
        int nextExternalIfIndex = 0;
        int nextInternalIfIndex = addresses.size() - 1;
        for (InetAddress addr : addresses) {
            String host = addr.getCanonicalHostName();
            if (!(addr.isLinkLocalAddress() || addr.isLoopbackAddress() || addr.isSiteLocalAddress() || addr.isMulticastAddress())) {
                this._hosts[nextExternalIfIndex++] = host;
                continue;
            }
            this._hosts[nextInternalIfIndex--] = host;
        }
        this.rescheduleTask();
    }

    public synchronized void setAddress(String host) throws SocketException, UnknownHostException {
        InetAddress address = InetAddress.getByName(host);
        if (address.isAnyLocalAddress()) {
            this.setAddresses(NetworkUtils.getLocalAddressesV4());
        } else {
            this.setAddresses(Collections.singletonList(address));
        }
    }

    public synchronized void setPort(int port) {
        this._port = port;
        this.rescheduleTask();
    }

    public synchronized void setLoad(int children, int maxChildren) {
        double load = maxChildren > 0 ? (double)children / (double)maxChildren : 0.0;
        this.setLoad(new FixedLoad(load));
    }

    public synchronized void setLoad(LoadProvider load) {
        double diff = Math.abs(this._load.getLoad() - load.getLoad());
        if (diff > this._brokerUpdateThreshold) {
            this.rescheduleTask();
        }
        this._load = load;
    }

    public synchronized void setLoginBroker(CellPath loginBroker) {
        this._loginBroker = loginBroker;
        this.rescheduleTask();
    }

    public synchronized CellPath getLoginBroker() {
        return (CellPath)this._loginBroker.clone();
    }

    public synchronized void setProtocolFamily(String protocolFamily) {
        this._protocolFamily = protocolFamily;
        this.rescheduleTask();
    }

    public synchronized String getProtocolFamily() {
        return this._protocolFamily;
    }

    public synchronized void setProtocolVersion(String protocolVersion) {
        this._protocolVersion = protocolVersion;
        this.rescheduleTask();
    }

    public synchronized String getProtocolVersion() {
        return this._protocolVersion;
    }

    public synchronized void setProtocolEngine(String protocolEngine) {
        this._protocolEngine = protocolEngine;
        this.rescheduleTask();
    }

    public synchronized String getProtocolEngine() {
        return this._protocolEngine;
    }

    public synchronized void setUpdateThreshold(double threshold) {
        this._brokerUpdateThreshold = threshold;
    }

    public synchronized double getUpdateThreshold() {
        return this._brokerUpdateThreshold;
    }

    public synchronized void setUpdateTime(long time) {
        if (time < 2L) {
            throw new IllegalArgumentException("Update time out of range");
        }
        this._brokerUpdateTime = time;
        this.rescheduleTask();
    }

    public synchronized long getUpdateTime() {
        return this._brokerUpdateTime;
    }

    public synchronized void setExecutor(ScheduledExecutorService executor) {
        this._executor = executor;
        this.rescheduleTask();
    }

    public synchronized void start() {
        this.scheduleTask();
    }

    public synchronized void stop() {
        if (this._task != null) {
            this._task.cancel(false);
            this._task = null;
        }
    }

    private void rescheduleTask() {
        if (this._task != null) {
            this._task.cancel(false);
            this.scheduleTask();
        }
    }

    private void scheduleTask() {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                LoginBrokerHandler.this.sendUpdate();
            }
        };
        this._task = this._executor.scheduleWithFixedDelay(command, 0L, this._currentBrokerUpdateTime, TimeUnit.SECONDS);
    }

    private static class FixedLoad
    implements LoadProvider {
        private double _load;

        public FixedLoad(double load) {
            this._load = load;
        }

        @Override
        public double getLoad() {
            return this._load;
        }
    }

    public static interface LoadProvider {
        public double getLoad();
    }
}

