/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class LockFile {
    private final File _file;
    private RandomAccessFile _lock;

    public LockFile(File file) {
        this._file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acquire() throws IOException, IllegalStateException {
        if (this._lock == null) {
            try (RandomAccessFile lock = new RandomAccessFile(this._file, "rw");){
                if (lock.getChannel().tryLock() == null) {
                    throw new IllegalStateException(String.format("Lock file [%s] is owned by another process", this._file));
                }
                this._lock = lock;
                lock = null;
            }
        }
    }

    public synchronized void release() throws IOException {
        if (this._lock != null) {
            this._lock.close();
            this._file.delete();
        }
    }
}

