/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;

public class DMCFRetryProxyHandler
implements InvocationHandler {
    protected Object delegate;
    private int timeout;

    public DMCFRetryProxyHandler(Object delegate) {
        this(delegate, -1);
    }

    public DMCFRetryProxyHandler(Object delegate, int timeout) {
        this.delegate = delegate;
        this.timeout = timeout;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.startsWith("createConnection")) {
            int ntry = this.timeout >= 0 ? this.timeout / 3 : 1000000;
            while (true) {
                try {
                    Object result = method.invoke(this.delegate, args);
                    return result;
                }
                catch (InvocationTargetException e) {
                    Throwable te = e.getTargetException();
                    if (te instanceof SQLException) {
                        System.out.println("createConnection(): Got exception " + te.getClass().getName() + ", SQLState: " + ((SQLException)te).getSQLState());
                        if (ntry-- <= 0) continue;
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        System.out.println("Sleep 3 s, try to get connection ... tries left: " + ntry);
                        continue;
                    }
                    throw te;
                    if (ntry > 0) continue;
                    throw te;
                }
                break;
            }
        }
        try {
            Object result;
            Object te = result = method.invoke(this.delegate, args);
            return te;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

