/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.util.FileCorruptedCacheException;
import diskCacheV111.util.FileExistsCacheException;
import diskCacheV111.util.FileInCacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.FileNotOnlineCacheException;
import diskCacheV111.util.LockedCacheException;
import diskCacheV111.util.MissingResourceCacheException;
import diskCacheV111.util.NotDirCacheException;
import diskCacheV111.util.NotFileCacheException;
import diskCacheV111.util.NotInTrashCacheException;
import diskCacheV111.util.OutOfDateCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.Message;
import java.io.Serializable;

public class CacheExceptionFactory {
    private CacheExceptionFactory() {
    }

    public static CacheException exceptionOf(int errorCode, String message) {
        return CacheExceptionFactory.exceptionOf(errorCode, message, null);
    }

    public static CacheException exceptionOf(int errorCode, String message, Throwable cause) {
        switch (errorCode) {
            case 204: {
                return new DiskErrorCacheException(message, cause);
            }
            case 10001: {
                return new FileNotFoundCacheException(message, cause);
            }
            case 10019: {
                return new FileNotOnlineCacheException(message, cause);
            }
            case 10007: {
                return new FileNotInCacheException(message, cause);
            }
            case 10008: {
                return new FileExistsCacheException(message, cause);
            }
            case 10010: {
                return new NotDirCacheException(message, cause);
            }
            case 10014: {
                return new NotFileCacheException(message, cause);
            }
            case 10017: {
                return new MissingResourceCacheException(message, cause);
            }
            case 10018: {
                return new PermissionDeniedCacheException(message, cause);
            }
            case 10020: {
                return new LockedCacheException(message, cause);
            }
            case 10016: {
                return new NotInTrashCacheException(message, cause);
            }
            case 10006: {
                return new TimeoutCacheException(message, cause);
            }
            case 10021: {
                return new OutOfDateCacheException(message, cause);
            }
            case 210: {
                return new FileInCacheException(message, cause);
            }
            case 10004: {
                return new FileCorruptedCacheException(message, cause);
            }
        }
        return new CacheException(errorCode, message, cause);
    }

    public static CacheException exceptionOf(Message message) {
        Serializable error = message.getErrorObject();
        if (error instanceof CacheException) {
            CacheException ce = (CacheException)error;
            return CacheExceptionFactory.exceptionOf(ce.getRc(), ce.getMessage());
        }
        return CacheExceptionFactory.exceptionOf(message.getReturnCode(), String.valueOf(error));
    }
}

