/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ForwardingListeningExecutorService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import dmg.cells.nucleus.CDC;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CDCListeningExecutorServiceDecorator
extends ForwardingListeningExecutorService {
    private final ListeningExecutorService _delegate;

    public CDCListeningExecutorServiceDecorator(ListeningExecutorService delegate) {
        this._delegate = delegate;
    }

    protected ListeningExecutorService delegate() {
        return this._delegate;
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return this.wrap(this._delegate.submit(this.wrap(task)));
    }

    public ListenableFuture<?> submit(Runnable task) {
        return this.wrap(this._delegate.submit(this.wrap(task)));
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return this.wrap(this._delegate.submit(this.wrap(task), result));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.wrap(this._delegate.invokeAll(this.wrap(tasks)));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.wrap(this._delegate.invokeAll(this.wrap(tasks), timeout, unit));
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this._delegate.invokeAny(this.wrap(tasks));
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this._delegate.invokeAny(this.wrap(tasks), timeout, unit);
    }

    public void execute(Runnable command) {
        this._delegate.execute(this.wrap(command));
    }

    private <T> ListenableFuture<T> wrap(final ListenableFuture<T> future) {
        return new ForwardingListenableFuture<T>(){

            public void addListener(Runnable listener, Executor exec) {
                super.addListener(CDCListeningExecutorServiceDecorator.this.wrap(listener), exec);
            }

            protected ListenableFuture<T> delegate() {
                return future;
            }
        };
    }

    private Runnable wrap(final Runnable task) {
        final CDC cdc = new CDC();
        return new Runnable(){

            @Override
            public void run() {
                try (CDC ignored = cdc.restore();){
                    task.run();
                }
            }
        };
    }

    private <T> Callable<T> wrap(final Callable<T> task) {
        final CDC cdc = new CDC();
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                try (CDC ignored = cdc.restore();){
                    Object v = task.call();
                    return v;
                }
            }
        };
    }

    private <T> Collection<? extends Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        return Lists.newArrayList((Iterable)Iterables.transform(tasks, (Function)new Function<Callable<T>, Callable<T>>(){

            public Callable<T> apply(Callable<T> task) {
                return CDCListeningExecutorServiceDecorator.this.wrap(task);
            }
        }));
    }

    private <T> List<Future<T>> wrap(List<Future<T>> futures) {
        return Lists.newArrayList((Iterable)Iterables.transform(futures, (Function)new Function<Future<T>, Future<T>>(){

            public Future<T> apply(Future<T> future) {
                return CDCListeningExecutorServiceDecorator.this.wrap((ListenableFuture)future);
            }
        }));
    }
}

