/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ForwardingExecutorService;
import dmg.cells.nucleus.CDC;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CDCExecutorServiceDecorator
extends ForwardingExecutorService {
    private final ExecutorService _delegate;

    public CDCExecutorServiceDecorator(ExecutorService delegate) {
        this._delegate = delegate;
    }

    protected ExecutorService delegate() {
        return this._delegate;
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this._delegate.submit(this.wrap(task));
    }

    public Future<?> submit(Runnable task) {
        return this._delegate.submit(this.wrap(task));
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this._delegate.submit(this.wrap(task), result);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this._delegate.invokeAll(this.wrap(tasks));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this._delegate.invokeAll(this.wrap(tasks), timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this._delegate.invokeAny(this.wrap(tasks));
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this._delegate.invokeAny(this.wrap(tasks), timeout, unit);
    }

    public void execute(Runnable command) {
        this._delegate.execute(this.wrap(command));
    }

    private Runnable wrap(final Runnable task) {
        final CDC cdc = new CDC();
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                cdc.restore();
                try {
                    task.run();
                }
                finally {
                    CDC.clear();
                }
            }
        };
    }

    private <T> Callable<T> wrap(final Callable<T> task) {
        final CDC cdc = new CDC();
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                cdc.restore();
                try {
                    Object v = task.call();
                    return v;
                }
                finally {
                    2 v0 = this;
                    v0.cdc.clear();
                }
            }
        };
    }

    private <T> Collection<? extends Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        return Lists.newArrayList((Iterable)Iterables.transform(tasks, (Function)new Function<Callable<T>, Callable<T>>(){

            public Callable<T> apply(Callable<T> task) {
                return CDCExecutorServiceDecorator.this.wrap(task);
            }
        }));
    }
}

