/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public final class AdjustableSemaphore {
    private final ResizeableSemaphore semaphore = new ResizeableSemaphore();
    private int maxPermits;

    public synchronized void setMaxPermits(int newMax) {
        Preconditions.checkArgument((newMax >= 0 ? 1 : 0) != 0);
        int delta = newMax - this.maxPermits;
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            this.semaphore.release(delta);
        } else {
            this.semaphore.reducePermits(delta *= -1);
        }
        this.maxPermits = newMax;
    }

    public void release() {
        this.semaphore.release();
    }

    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        return this.semaphore.tryAcquire(permits, timeout, unit);
    }

    public boolean tryAcquire() {
        return this.semaphore.tryAcquire();
    }

    public synchronized int getMaxPermits() {
        return this.maxPermits;
    }

    public synchronized int getUsedPermits() {
        return this.maxPermits - this.semaphore.availablePermits();
    }

    private static final class ResizeableSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 1L;

        ResizeableSemaphore() {
            super(0);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

